/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.jstl.constant.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.silverpeas.jstl.constant.reflect.FieldPathParser;

public class ClassConstantInspector {
    private Field field;

    public ClassConstantInspector(String constantPath) throws ClassNotFoundException, NoSuchFieldException {
        FieldPathParser parser = new FieldPathParser(constantPath);
        this.field = Class.forName(parser.getDeclaringClassName()).getField(parser.getFieldName());
        if (!(Modifier.isPublic(this.field.getModifiers()) && Modifier.isStatic(this.field.getModifiers()) && Modifier.isFinal(this.field.getModifiers()))) {
            throw new IllegalArgumentException("Field " + constantPath + " is not a public static final field");
        }
    }

    public Object getValue() throws IllegalAccessException, InstantiationException {
        return this.field.get(null);
    }

    public static Object getValue(String constantName) throws NoSuchFieldException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        return new ClassConstantInspector(constantName).getValue();
    }
}

