/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.look.web.delegate;

import com.silverpeas.look.LookHelper;
import com.silverpeas.look.SilverpeasLook;
import com.silverpeas.personalization.UserMenuDisplay;
import com.silverpeas.personalization.UserPreferences;
import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.beans.admin.SpaceInstLight;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.beans.admin.UserFavoriteSpaceManager;
import com.stratelia.webactiv.organization.DAOFactory;
import com.stratelia.webactiv.organization.UserFavoriteSpaceVO;
import com.stratelia.webactiv.util.viewGenerator.html.GraphicElementFactory;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.silverpeas.core.admin.OrganisationController;
import org.silverpeas.core.admin.OrganisationControllerFactory;

public class LookWebDelegate {
    private OrganisationController organizationController;
    private final UserDetail user;
    private final UserPreferences userPreference;
    private final LookHelper lookHelper;
    private final GraphicElementFactory gef;
    private List<UserFavoriteSpaceVO> userFavoriteSpaces = null;
    private List<String> userFavoriteSpaceIds = null;

    public String getUserFavorite(SpaceInstLight space, boolean forceGettingFavorite) {
        String favorite = "false";
        if (forceGettingFavorite || UserMenuDisplay.DISABLE != this.getUserMenuDisplay()) {
            if (this.getUserFavoriteSpaceIds().contains(space.getShortId())) {
                favorite = "true";
            } else if (UserFavoriteSpaceManager.containsFavoriteSubSpace((String)space.getShortId(), this.getUserFavoriteSpaces(), (OrganisationController)this.getOrganisationController(), (String)this.getUserId())) {
                favorite = "contains";
            }
        }
        return favorite;
    }

    public void addToUserFavorites(SpaceInstLight space) {
        DAOFactory.getUserFavoriteSpaceDAO().addUserFavoriteSpace(new UserFavoriteSpaceVO(this.getUser(), space));
        this.clearFavoriteCache();
    }

    public void removeFromUserFavorites(SpaceInstLight space) {
        DAOFactory.getUserFavoriteSpaceDAO().removeUserFavoriteSpace(new UserFavoriteSpaceVO(this.getUser(), space));
        this.clearFavoriteCache();
    }

    public String getLook(SpaceInstLight space) {
        String look = space.getLook();
        while (!space.isRoot() && !StringUtil.isDefined((String)look)) {
            space = this.getOrganisationController().getSpaceInstLightById(space.getFatherId());
            look = space.getLook();
        }
        if (!StringUtil.isDefined((String)look)) {
            look = this.getGraphicalElements().getDefaultLookName();
        }
        return look;
    }

    public String getWallpaper(SpaceInstLight space) {
        String wallpaper = SilverpeasLook.getSilverpeasLook().getWallpaperOfSpace(space.getShortId());
        return wallpaper == null ? "" : wallpaper;
    }

    public String getCSS(SpaceInstLight space) {
        String css = SilverpeasLook.getSilverpeasLook().getCSSOfSpace(space.getShortId());
        return css == null ? "" : css;
    }

    private UserMenuDisplay getUserMenuDisplay() {
        return this.getHelper().getDisplayUserMenu();
    }

    private List<UserFavoriteSpaceVO> getUserFavoriteSpaces() {
        if (this.userFavoriteSpaces == null) {
            this.userFavoriteSpaces = DAOFactory.getUserFavoriteSpaceDAO().getListUserFavoriteSpace(this.getUserId());
        }
        return this.userFavoriteSpaces;
    }

    private List<String> getUserFavoriteSpaceIds() {
        if (this.userFavoriteSpaceIds == null) {
            this.userFavoriteSpaceIds = new ArrayList<String>();
            for (UserFavoriteSpaceVO favoriteUserSpace : this.getUserFavoriteSpaces()) {
                this.userFavoriteSpaceIds.add("" + favoriteUserSpace.getSpaceId());
            }
        }
        return this.userFavoriteSpaceIds;
    }

    private void clearFavoriteCache() {
        this.userFavoriteSpaces = null;
        this.userFavoriteSpaceIds = null;
    }

    public static LookWebDelegate getInstance(UserDetail user, UserPreferences userPreference, HttpServletRequest request) {
        return new LookWebDelegate(user, userPreference, request);
    }

    private LookWebDelegate(UserDetail user, UserPreferences userPreference, HttpServletRequest request) {
        this.user = user;
        this.userPreference = userPreference;
        this.lookHelper = (LookHelper)request.getSession().getAttribute("Silverpeas_LookHelper");
        this.gef = (GraphicElementFactory)request.getSession().getAttribute("SessionGraphicElementFactory");
        if (this.lookHelper != null) {
            this.initializeUserMenuDisplay(request);
        }
    }

    private void initializeUserMenuDisplay(HttpServletRequest request) {
        UserMenuDisplay displayMode = this.getHelper().getDisplayUserMenu();
        if (this.getHelper().isMenuPersonalisationEnabled()) {
            if (StringUtil.isDefined((String)request.getParameter("UserMenuDisplayMode"))) {
                displayMode = UserMenuDisplay.valueOf((String)request.getParameter("UserMenuDisplayMode"));
            } else if (this.userPreference.getDisplay().isNotDefault() && !UserMenuDisplay.ALL.equals((Object)displayMode) && !UserMenuDisplay.BOOKMARKS.equals((Object)displayMode)) {
                displayMode = this.userPreference.getDisplay();
            }
        }
        this.getHelper().setDisplayUserMenu(displayMode);
    }

    private UserDetail getUser() {
        return this.user;
    }

    private String getUserId() {
        return this.getUser().getId();
    }

    public LookHelper getHelper() {
        return this.lookHelper;
    }

    private GraphicElementFactory getGraphicalElements() {
        return this.gef;
    }

    private OrganisationController getOrganisationController() {
        if (this.organizationController == null) {
            OrganisationControllerFactory.getFactory();
            this.organizationController = OrganisationControllerFactory.getOrganisationController();
        }
        return this.organizationController;
    }
}

