/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.node.web;

import com.silverpeas.annotation.Authorized;
import com.silverpeas.annotation.RequestScoped;
import com.silverpeas.annotation.Service;
import com.silverpeas.web.RESTWebService;
import com.stratelia.webactiv.SilverpeasRole;
import com.stratelia.webactiv.util.EJBUtilitaire;
import com.stratelia.webactiv.util.JNDINames;
import com.stratelia.webactiv.util.node.control.NodeBm;
import com.stratelia.webactiv.util.node.model.NodePK;
import java.util.ArrayList;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.node.web.NodeEntity;

@Service
@RequestScoped
@Path(value="nodes/{instanceId}")
@Authorized
public class ListNodeResource
extends RESTWebService {
    @PathParam(value="instanceId")
    private String instanceId;

    @Override
    public String getComponentId() {
        return this.instanceId;
    }

    private NodeBm getNodeBm() {
        NodeBm nodeBm = null;
        try {
            nodeBm = (NodeBm)EJBUtilitaire.getEJBObjectRef((String)JNDINames.NODEBM_EJBHOME, NodeBm.class);
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        return nodeBm;
    }

    private boolean isUserAdmin() {
        String[] profiles;
        for (String profile : profiles = this.getOrganisationController().getUserProfiles(this.getUserDetail().getId(), this.getComponentId())) {
            if (!SilverpeasRole.admin.equals((Object)SilverpeasRole.valueOf((String)profile))) continue;
            return true;
        }
        return false;
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public NodeEntity[] updateListNode(NodeEntity[] newListNode) {
        if (this.isUserAdmin()) {
            ArrayList<NodePK> nodePKs = new ArrayList<NodePK>();
            for (NodeEntity nodeEntity : newListNode) {
                nodePKs.add(nodeEntity.toNodePK());
            }
            this.getNodeBm().sortNodes(nodePKs);
        }
        return newListNode;
    }
}

