/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.node.web;

import com.silverpeas.util.i18n.Translation;
import com.silverpeas.web.Exposable;
import com.stratelia.webactiv.util.node.model.NodeDetail;
import com.stratelia.webactiv.util.node.model.NodePK;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.owasp.encoder.Encode;
import org.silverpeas.node.web.NodeAttrEntity;
import org.silverpeas.node.web.NodeTranslationEntity;

@XmlRootElement
public class NodeEntity
implements Exposable {
    private static final long serialVersionUID = -5740937039604775733L;
    @XmlElement(defaultValue="")
    private URI uri;
    @XmlElement(required=true)
    private String data;
    @XmlElement(required=true)
    private NodeAttrEntity attr;
    @XmlElement
    private NodeEntity[] children;
    @XmlElement(defaultValue="")
    private URI childrenURI;
    @XmlElement
    private NodeTranslationEntity[] translations;
    @XmlElement(required=true)
    private String state = "closed";

    public NodeEntity() {
    }

    public static NodeEntity fromNodeDetail(NodeDetail node, URI uri) {
        return new NodeEntity(node, uri, null);
    }

    public static NodeEntity fromNodeDetail(NodeDetail node, URI uri, String lang) {
        return new NodeEntity(node, uri, lang);
    }

    public static NodeEntity fromNodeDetail(NodeDetail node, String uri) {
        return NodeEntity.fromNodeDetail(node, NodeEntity.getURI(uri), null);
    }

    public static NodeEntity fromNodeDetail(NodeDetail node, String uri, String lang) {
        return NodeEntity.fromNodeDetail(node, NodeEntity.getURI(uri), lang);
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    public void setURI(URI uri) {
        this.uri = uri;
    }

    private NodeEntity(NodeDetail node, URI uri, String lang) {
        this.data = Encode.forHtml((String)node.getName(lang));
        this.uri = uri;
        this.attr = NodeAttrEntity.fromNodeDetail(node, uri, lang);
        Map theTranslations = node.getTranslations();
        ArrayList<NodeTranslationEntity> translationEntities = new ArrayList<NodeTranslationEntity>();
        for (Translation translation : theTranslations.values()) {
            NodeTranslationEntity translationEntity = new NodeTranslationEntity(translation.getId(), translation.getLanguage(), node);
            translationEntities.add(translationEntity);
        }
        this.translations = translationEntities.toArray(new NodeTranslationEntity[0]);
        this.setChildrenURI(this.getChildrenURI(uri));
        if (node.getChildrenDetails() != null) {
            ArrayList<NodeEntity> entities = new ArrayList<NodeEntity>();
            for (NodeDetail child : node.getChildrenDetails()) {
                URI childURI = this.getChildURI(uri, child.getNodePK().getId());
                NodeEntity childEntity = NodeEntity.fromNodeDetail(child, childURI, lang);
                childEntity.setChildrenURI(this.getChildrenURI(childURI));
                entities.add(childEntity);
            }
            this.children = entities.toArray(new NodeEntity[0]);
        }
    }

    private URI getChildURI(URI parentURI, String childId) {
        try {
            return new URI(parentURI + "/" + childId);
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(NodeEntity.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private static URI getURI(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(NodeEntity.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public void setChildren(NodeEntity[] children) {
        this.children = (NodeEntity[])children.clone();
    }

    public NodeEntity[] getChildren() {
        return this.children;
    }

    public final void setData(String data) {
        this.data = data;
    }

    public String getData() {
        return this.data;
    }

    public final void setAttr(NodeAttrEntity attr) {
        this.attr = attr;
    }

    public NodeAttrEntity getAttr() {
        return this.attr;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public final void setChildrenURI(URI childrenURI) {
        this.childrenURI = childrenURI;
        this.attr.setChildrenURI(childrenURI);
    }

    public final URI getChildrenURI(URI uri) {
        try {
            return new URI(uri + "/children");
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(NodeEntity.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public URI getChildrenURI() {
        return this.childrenURI;
    }

    public final void setTranslations(NodeTranslationEntity[] translations) {
        this.translations = translations != null ? (NodeTranslationEntity[])translations.clone() : null;
    }

    public NodeTranslationEntity[] getTranslations() {
        return this.translations;
    }

    public NodePK toNodePK() {
        NodePK nodePk = new NodePK(this.attr.getId(), this.attr.getComponentId());
        return nodePk;
    }
}

