/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.node.web;

import com.silverpeas.annotation.RequestScoped;
import com.silverpeas.annotation.Service;
import com.silverpeas.sharing.model.Ticket;
import com.silverpeas.sharing.security.ShareableNode;
import com.silverpeas.sharing.services.SharingServiceFactory;
import com.silverpeas.web.RESTWebService;
import com.stratelia.webactiv.util.EJBUtilitaire;
import com.stratelia.webactiv.util.JNDINames;
import com.stratelia.webactiv.util.node.control.NodeBm;
import com.stratelia.webactiv.util.node.model.NodeDetail;
import com.stratelia.webactiv.util.node.model.NodePK;
import java.net.URI;
import java.util.ArrayList;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.node.web.NodeEntity;

@Service
@RequestScoped
@Path(value="nodes/{componentId}/{token}")
public class NodeResource
extends RESTWebService {
    @PathParam(value="componentId")
    private String componentId;
    @PathParam(value="token")
    private String token;

    @GET
    @Produces(value={"application/json"})
    public NodeEntity getRoot() {
        NodeDetail node = this.getNodeDetail("0");
        if (!this.isNodeReadable(node)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        URI uri = this.getUriInfo().getRequestUriBuilder().path(node.getNodePK().getId()).build(new Object[0]);
        if (this.getUriInfo().getRequestUri().toString().endsWith("/0")) {
            uri = this.getUriInfo().getRequestUri();
        }
        NodeEntity entity = NodeEntity.fromNodeDetail(node, uri);
        entity.setState("open");
        entity.setChildren(this.removeSpecialNodes(entity.getChildren()));
        return entity;
    }

    @GET
    @Path(value="{path: [0-9]+(/[0-9]+)*}")
    @Produces(value={"application/json"})
    public NodeEntity getNode(@PathParam(value="path") String path) {
        String nodeId = this.getNodeIdFromURI(path);
        if (nodeId.equals("0")) {
            return this.getRoot();
        }
        NodeDetail node = this.getNodeDetail(nodeId);
        if (!this.isNodeReadable(node)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        URI uri = this.getUriInfo().getRequestUri();
        return NodeEntity.fromNodeDetail(node, uri);
    }

    @GET
    @Path(value="{path: [0-9]+(/[0-9]+)*/children}")
    @Produces(value={"application/json"})
    public NodeEntity[] getChildren(@PathParam(value="path") String path) {
        String[] nodeIds = path.split("/");
        String nodeId = nodeIds[nodeIds.length - 2];
        NodeDetail node = this.getNodeDetail(nodeId);
        if (!this.isNodeReadable(node)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        String requestUri = this.getUriInfo().getRequestUri().toString();
        String uri = requestUri.substring(0, requestUri.lastIndexOf("/"));
        NodeEntity entity = NodeEntity.fromNodeDetail(node, uri);
        if (nodeId.equals("0")) {
            return this.removeSpecialNodes(entity.getChildren());
        }
        return entity.getChildren();
    }

    @Override
    public String getComponentId() {
        return this.componentId;
    }

    private String getNodeIdFromURI(String uri) {
        String[] nodeIds = uri.split("/");
        return nodeIds[nodeIds.length - 1];
    }

    private NodeDetail getNodeDetail(String id) {
        return this.getNodeBm().getDetail(this.getNodePK(id));
    }

    private NodeEntity[] removeSpecialNodes(NodeEntity[] nodes) {
        ArrayList<NodeEntity> result = new ArrayList<NodeEntity>();
        for (NodeEntity node : nodes) {
            if (node.getAttr().getId().equals("1") || node.getAttr().getId().equals("2")) continue;
            result.add(node);
        }
        return result.toArray(new NodeEntity[0]);
    }

    private NodePK getNodePK(String id) {
        return new NodePK(id, this.getComponentId());
    }

    private boolean isNodeReadable(NodeDetail node) {
        ShareableNode nodeResource = new ShareableNode(this.token, node);
        Ticket ticket = SharingServiceFactory.getSharingTicketService().getTicket(this.token);
        return ticket != null && ticket.getAccessControl().isReadable(nodeResource);
    }

    private NodeBm getNodeBm() {
        NodeBm nodeBm = null;
        try {
            nodeBm = (NodeBm)EJBUtilitaire.getEJBObjectRef((String)JNDINames.NODEBM_EJBHOME, NodeBm.class);
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        return nodeBm;
    }
}

