/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.password.web;

import com.silverpeas.util.i18n.I18NHelper;
import com.silverpeas.web.RESTWebService;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.password.rule.PasswordRule;
import org.silverpeas.password.service.PasswordCheck;
import org.silverpeas.password.web.PasswordCheckEntity;
import org.silverpeas.password.web.PasswordRuleEntity;

public abstract class AbstractPasswordResource
extends RESTWebService {
    @Override
    public String getComponentId() {
        return "";
    }

    protected PasswordRuleEntity asWebEntity(PasswordRule rule) {
        this.checkNotFoundStatus(rule);
        return PasswordRuleEntity.createFrom(rule, this.getLanguage());
    }

    protected PasswordCheckEntity asWebEntity(PasswordCheck check) {
        this.checkNotFoundStatus(check);
        return PasswordCheckEntity.createFrom(check);
    }

    private void checkNotFoundStatus(Object object) {
        if (object == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    protected String getLanguage() {
        String language = I18NHelper.defaultLanguage;
        if (this.getUserDetail() != null) {
            language = this.getUserPreferences().getLanguage();
        }
        return language;
    }
}

