/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.password.web;

import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.password.rule.PasswordRule;
import org.silverpeas.password.service.PasswordCheck;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PasswordCheckEntity {
    @XmlElement
    private boolean isCorrect;
    @XmlElement
    private boolean isRuleCombinationRespected;
    @XmlElement
    private Collection<String> requiredRuleIdsInError = new ArrayList<String>();
    @XmlElement
    private Collection<String> combinedRuleIdsInError = new ArrayList<String>();

    public static PasswordCheckEntity createFrom(PasswordCheck passwordCheck) {
        return new PasswordCheckEntity(passwordCheck);
    }

    private PasswordCheckEntity(PasswordCheck passwordCheck) {
        this.isCorrect = passwordCheck.isCorrect();
        this.isRuleCombinationRespected = passwordCheck.isRuleCombinationRespected();
        for (PasswordRule rule : passwordCheck.getRequiredRulesInError()) {
            this.requiredRuleIdsInError.add(rule.getType().name());
        }
        for (PasswordRule rule : passwordCheck.getCombinedRulesInError()) {
            this.combinedRuleIdsInError.add(rule.getType().name());
        }
    }

    protected PasswordCheckEntity() {
    }

    public boolean isCorrect() {
        return this.isCorrect;
    }

    public boolean isRuleCombinationRespected() {
        return this.isRuleCombinationRespected;
    }

    public Collection<String> getRequiredRuleIdsInError() {
        return this.requiredRuleIdsInError;
    }

    public Collection<String> getCombinedRuleIdsInError() {
        return this.combinedRuleIdsInError;
    }
}

