/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.password.web;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.password.web.PasswordRuleEntity;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PasswordPolicyEntity {
    @XmlElement(defaultValue="")
    private Map<String, PasswordRuleEntity> rules = new LinkedHashMap<String, PasswordRuleEntity>();
    @XmlElement
    private int nbMatchingCombinedRules = 0;
    @XmlElement(defaultValue="")
    private Map<String, PasswordRuleEntity> combinedRules = new LinkedHashMap<String, PasswordRuleEntity>();
    @XmlElement(defaultValue="")
    private String extraRuleMessage = "";

    public static PasswordPolicyEntity createFrom(int nbMatchingCombinedRules, String extraRuleMessage) {
        return new PasswordPolicyEntity(nbMatchingCombinedRules, extraRuleMessage);
    }

    private PasswordPolicyEntity(int nbMatchingCombinedRules, String extraRuleMessage) {
        this.nbMatchingCombinedRules = nbMatchingCombinedRules;
        this.extraRuleMessage = extraRuleMessage;
    }

    protected PasswordPolicyEntity() {
    }

    public PasswordPolicyEntity addRule(PasswordRuleEntity rule) {
        this.rules.put(rule.getType(), rule);
        return this;
    }

    public PasswordPolicyEntity addCombinedRule(PasswordRuleEntity rule) {
        this.combinedRules.put(rule.getType(), rule);
        return this;
    }

    public Map<String, PasswordRuleEntity> getRules() {
        return this.rules;
    }

    public int getNbMatchingCombinedRules() {
        return this.nbMatchingCombinedRules;
    }

    public Map<String, PasswordRuleEntity> getCombinedRules() {
        return this.combinedRules;
    }

    public String getExtraRuleMessage() {
        return this.extraRuleMessage;
    }
}

