/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.password.web;

import com.silverpeas.annotation.Authenticated;
import com.silverpeas.annotation.RequestScoped;
import com.silverpeas.annotation.Service;
import com.silverpeas.web.UserPriviledgeValidation;
import com.stratelia.webactiv.util.ResourceLocator;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.password.rule.PasswordRule;
import org.silverpeas.password.service.PasswordServiceFactory;
import org.silverpeas.password.web.AbstractPasswordResource;
import org.silverpeas.password.web.PasswordCheckEntity;
import org.silverpeas.password.web.PasswordEntity;
import org.silverpeas.password.web.PasswordPolicyEntity;

@Service
@RequestScoped
@Path(value="password")
@Authenticated
public class PasswordResource
extends AbstractPasswordResource {
    protected static ResourceLocator settings = new ResourceLocator("org.silverpeas.password.settings.password", "");
    protected static int nbMatchingCombinedRules = settings.getInteger("password.combination.nbMatchingRules", 0);

    @Override
    public void validateUserAuthentication(UserPriviledgeValidation validation) throws WebApplicationException {
        block2: {
            try {
                super.validateUserAuthentication(validation);
            }
            catch (WebApplicationException wae) {
                if (Response.Status.UNAUTHORIZED.getStatusCode() == wae.getResponse().getStatus()) break block2;
                throw wae;
            }
        }
    }

    @GET
    @Path(value="policy")
    @Produces(value={"application/json"})
    public PasswordPolicyEntity getPolicy() {
        try {
            PasswordPolicyEntity passwordPolicy = PasswordPolicyEntity.createFrom(nbMatchingCombinedRules, PasswordServiceFactory.getPasswordService().getExtraRuleMessage(this.getLanguage()));
            for (PasswordRule rule : PasswordServiceFactory.getPasswordService().getRequiredRules()) {
                passwordPolicy.addRule(this.asWebEntity(rule));
            }
            for (PasswordRule rule : PasswordServiceFactory.getPasswordService().getCombinedRules()) {
                passwordPolicy.addCombinedRule(this.asWebEntity(rule));
            }
            return passwordPolicy;
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @POST
    @Path(value="policy/checking")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public PasswordCheckEntity checking(PasswordEntity password) {
        return this.asWebEntity(PasswordServiceFactory.getPasswordService().check(password.getValue()));
    }
}

