/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.publication.web;

import com.silverpeas.attachment.web.AttachmentEntity;
import com.silverpeas.profile.web.UserProfileEntity;
import com.silverpeas.web.Exposable;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.publication.model.PublicationDetail;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlElement;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.node.web.NodeEntity;

public class PublicationEntity
implements Exposable {
    private static final long serialVersionUID = 7746081841765736096L;
    @XmlElement(defaultValue="")
    private URI uri;
    @XmlElement(defaultValue="")
    private String name;
    @XmlElement(defaultValue="")
    private String description;
    @XmlElement
    private Date updateDate;
    @XmlElement
    private AttachmentEntity[] attachments;
    @XmlElement
    private UserProfileEntity creator;
    @XmlElement
    private UserProfileEntity lastUpdater;

    @Override
    public URI getURI() {
        return this.uri;
    }

    public static PublicationEntity fromPublicationDetail(PublicationDetail publication, URI uri) {
        return new PublicationEntity(publication, uri);
    }

    private PublicationEntity(PublicationDetail publication, URI uri) {
        this.setName(publication.getName());
        this.setDescription(publication.getDescription());
        this.setUri(uri);
        this.setUpdateDate(publication.getUpdateDate());
        this.creator = UserProfileEntity.fromUser(publication.getCreator());
        this.lastUpdater = UserProfileEntity.fromUser(UserDetail.getById((String)publication.getUpdaterId()));
    }

    public PublicationEntity withAttachments(Collection<SimpleDocument> attachmentDetails, String baseURI, String token) {
        if (attachmentDetails != null && !attachmentDetails.isEmpty()) {
            ArrayList<AttachmentEntity> entities = new ArrayList<AttachmentEntity>(attachmentDetails.size());
            for (SimpleDocument attachment : attachmentDetails) {
                SimpleDocument document = attachment.getLastPublicVersion();
                if (document == null) continue;
                AttachmentEntity entity = AttachmentEntity.fromAttachment(document);
                URI sharedUri = this.getAttachmentSharedURI(attachment, baseURI, token);
                entity.setSharedUri(sharedUri);
                entities.add(entity);
            }
            this.attachments = entities.toArray(new AttachmentEntity[entities.size()]);
        }
        return this;
    }

    private URI getAttachmentSharedURI(SimpleDocument attachment, String baseURI, String token) {
        URI sharedUri;
        try {
            sharedUri = new URI(baseURI + "attachments/" + attachment.getInstanceId() + "/" + token + "/" + attachment.getId() + "/" + URLEncoder.encode(attachment.getFilename(), "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(NodeEntity.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(NodeEntity.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
        return sharedUri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }
}

