/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.publication.web;

import com.silverpeas.annotation.RequestScoped;
import com.silverpeas.annotation.Service;
import com.silverpeas.sharing.model.Ticket;
import com.silverpeas.sharing.security.ShareableNode;
import com.silverpeas.sharing.services.SharingServiceFactory;
import com.silverpeas.web.RESTWebService;
import com.stratelia.webactiv.util.EJBUtilitaire;
import com.stratelia.webactiv.util.JNDINames;
import com.stratelia.webactiv.util.WAPrimaryKey;
import com.stratelia.webactiv.util.node.control.NodeBm;
import com.stratelia.webactiv.util.node.model.NodeDetail;
import com.stratelia.webactiv.util.node.model.NodePK;
import com.stratelia.webactiv.util.publication.control.PublicationBm;
import com.stratelia.webactiv.util.publication.model.PublicationDetail;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.attachment.AttachmentServiceFactory;
import org.silverpeas.publication.web.PublicationEntity;

@Service
@RequestScoped
@Path(value="publications/{componentId}/{token}")
public class PublicationResource
extends RESTWebService {
    @PathParam(value="componentId")
    private String componentId;
    @PathParam(value="token")
    private String token;

    @Override
    public String getComponentId() {
        return this.componentId;
    }

    @GET
    @Produces(value={"application/json"})
    public PublicationEntity[] getPublications(@QueryParam(value="node") String nodeId, @QueryParam(value="withAttachments") boolean withAttachments) {
        NodePK nodePK = this.getNodePK(nodeId);
        if (!this.isNodeReadable(nodePK)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        Collection publications = this.getPublicationBm().getDetailsByFatherPK(nodePK, null, true);
        String baseUri = this.getUriInfo().getAbsolutePath().toString();
        ArrayList<PublicationEntity> entities = new ArrayList<PublicationEntity>();
        for (PublicationDetail publication : publications) {
            if (!publication.isValid()) continue;
            URI uri = this.getURI(publication, baseUri);
            PublicationEntity entity = PublicationEntity.fromPublicationDetail(publication, uri);
            if (withAttachments) {
                List attachments = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKey((WAPrimaryKey)publication.getPK(), null);
                entity.withAttachments(attachments, this.getUriInfo().getBaseUri().toString(), this.token);
            }
            entities.add(entity);
        }
        return entities.toArray(new PublicationEntity[entities.size()]);
    }

    private URI getURI(PublicationDetail publication, String baseUri) {
        URI uri;
        try {
            uri = new URI(baseUri + "/publication/" + publication.getPK().getId());
        }
        catch (URISyntaxException e) {
            Logger.getLogger(PublicationResource.class.getName()).log(Level.SEVERE, null, e);
            throw new RuntimeException(e.getMessage(), e);
        }
        return uri;
    }

    private NodePK getNodePK(String nodeId) {
        return new NodePK(nodeId, this.getComponentId());
    }

    private boolean isNodeReadable(NodePK nodePK) {
        NodeDetail node = this.getNodeBm().getDetail(nodePK);
        ShareableNode nodeResource = new ShareableNode(this.token, node);
        Ticket ticket = SharingServiceFactory.getSharingTicketService().getTicket(this.token);
        return ticket != null && ticket.getAccessControl().isReadable(nodeResource);
    }

    private NodeBm getNodeBm() {
        try {
            return (NodeBm)EJBUtilitaire.getEJBObjectRef((String)JNDINames.NODEBM_EJBHOME, NodeBm.class);
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private PublicationBm getPublicationBm() {
        try {
            return (PublicationBm)EJBUtilitaire.getEJBObjectRef((String)JNDINames.PUBLICATIONBM_EJBHOME, PublicationBm.class);
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

