/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.security.web;

import com.silverpeas.annotation.Authorized;
import com.silverpeas.util.security.CipherKeyUpdateException;
import com.silverpeas.util.security.ContentEncryptionService;
import com.silverpeas.util.security.DefaultContentEncryptionService;
import com.silverpeas.web.RESTWebService;
import com.stratelia.webactiv.util.ResourceLocator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.silverpeas.util.crypto.CryptoException;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="request")
@Path(value="security/cipherkey")
@Authorized
public class CipherKeyResource
extends RESTWebService {
    public static final String WEB_PATH = "security/cipherkey";
    protected static final String INVALID_CIPHER_KEY = "crypto.invalidKey";
    protected static final String CIPHER_KEY_UPDATE_FAILURE = "crypto.keyUpdateFailure";
    protected static final String CIPHER_RENEW_FAILURE = "crypto.cipherRenewFailure";
    protected static final String CIPHER_KEY_IMPORT_SUCCESS = "crypto.importOk";
    @Inject
    private DefaultContentEncryptionService contentEncryptionService;

    @Override
    public String getComponentId() {
        return "ADMIN";
    }

    @GET
    @Produces(value={"text/plain"})
    public Response getToto() {
        return Response.ok((Object)"Toto").build();
    }

    @PUT
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response setCipherKey(String cipherKey) {
        Response status;
        ResourceLocator messages = new ResourceLocator("org.silverpeas.crypto.multilang.cryptoBundle", this.getUserPreferences().getLanguage());
        try {
            this.getContentEncryptionService().updateCipherKey(cipherKey);
            status = Response.ok((Object)messages.getString(CIPHER_KEY_IMPORT_SUCCESS)).build();
        }
        catch (AssertionError e) {
            CipherKeyResource.logError((Throwable)((Object)e));
            String message = CipherKeyResource.formatMessage(messages.getString(INVALID_CIPHER_KEY), ((Throwable)((Object)e)).getMessage());
            status = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).build();
        }
        catch (CipherKeyUpdateException e) {
            CipherKeyResource.logError(e);
            String message = CipherKeyResource.formatMessage(messages.getString(CIPHER_KEY_UPDATE_FAILURE), e.getMessage());
            status = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)message).build();
        }
        catch (CryptoException e) {
            CipherKeyResource.logError(e);
            String message = CipherKeyResource.formatMessage(messages.getString(CIPHER_RENEW_FAILURE), e.getMessage());
            status = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)message).build();
        }
        return status;
    }

    private ContentEncryptionService getContentEncryptionService() {
        return this.contentEncryptionService;
    }

    private static String formatMessage(String pattern, String value) {
        String msg = pattern;
        if (!pattern.endsWith("\n")) {
            msg = msg + " ";
        }
        return msg + value;
    }

    private static void logError(Throwable ex) {
        Logger.getLogger(CipherKeyResource.class.getSimpleName()).log(Level.SEVERE, ex.getMessage(), ex);
    }
}

