/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.servlet;

import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.util.DateUtil;
import java.text.ParseException;
import java.util.Date;
import javax.servlet.ServletRequest;
import org.apache.commons.lang.NotImplementedException;

public class ServletRequestWrapper {
    private final ServletRequest request;
    private final String language;

    public ServletRequestWrapper(ServletRequest request, String language) {
        this.request = request;
        this.language = language;
    }

    protected ServletRequest getRequest() {
        return this.request;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setAttribute(String attributeName, Object object) {
        this.request.setAttribute(attributeName, object);
    }

    public Object getAttribute(String attributeName) {
        return this.request.getAttribute(attributeName);
    }

    public Long getAttributeAsLong(String attributeName) {
        return this.asLong(this.getAttribute(attributeName));
    }

    public String getParameter(String parameterName) {
        return this.request.getParameter(parameterName);
    }

    public boolean getParameterAsBoolean(String parameterName) {
        return this.asBoolean(this.getParameter(parameterName));
    }

    public Long getParameterAsLong(String parameterName) {
        return this.asLong(this.getParameter(parameterName));
    }

    public Date getParameterAsDate(String dateParameterName) throws ParseException {
        return this.asDate(this.getParameter(dateParameterName), null);
    }

    public Date getParameterAsDate(String dateParameterName, String hourParameterName) throws ParseException {
        return this.asDate(this.getParameter(dateParameterName), this.getParameter(hourParameterName));
    }

    private <T> boolean asBoolean(T object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            String typedObject = (String)object;
            return StringUtil.getBooleanValue((String)typedObject);
        }
        if (object != null) {
            throw new NotImplementedException();
        }
        return false;
    }

    private <T> Long asLong(T object) {
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object instanceof String) {
            String typedObject = (String)object;
            if (StringUtil.isLong((String)typedObject)) {
                return Long.valueOf(typedObject);
            }
            return null;
        }
        if (object != null) {
            throw new NotImplementedException();
        }
        return null;
    }

    private <T> Date asDate(T date, T hour) throws ParseException {
        if (date instanceof String) {
            String typedDate = (String)date;
            String typedHour = (String)hour;
            if (StringUtil.isDefined((String)typedDate)) {
                return DateUtil.stringToDate((String)typedDate, (String)typedHour, (String)this.language);
            }
            return null;
        }
        if (date != null) {
            throw new NotImplementedException();
        }
        return null;
    }
}

