/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.servlets;

import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.beans.admin.UserDetail;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.silverpeas.authentication.AuthenticationCredential;
import org.silverpeas.authentication.exception.AuthenticationException;
import org.silverpeas.authentication.verifier.AuthenticationUserVerifierFactory;
import org.silverpeas.authentication.verifier.UserCanLoginVerifier;
import org.silverpeas.servlets.credentials.ChangeExpiredPasswordHandler;
import org.silverpeas.servlets.credentials.ChangePasswordFromLoginHandler;
import org.silverpeas.servlets.credentials.ChangePasswordHandler;
import org.silverpeas.servlets.credentials.ChangeQuestionHandler;
import org.silverpeas.servlets.credentials.EffectiveChangePasswordBeforeExpirationHandler;
import org.silverpeas.servlets.credentials.EffectiveChangePasswordFromLoginHandler;
import org.silverpeas.servlets.credentials.EffectiveChangePasswordHandler;
import org.silverpeas.servlets.credentials.ForcePasswordChangeHandler;
import org.silverpeas.servlets.credentials.ForgotPasswordHandler;
import org.silverpeas.servlets.credentials.FunctionHandler;
import org.silverpeas.servlets.credentials.LoginQuestionHandler;
import org.silverpeas.servlets.credentials.NewRegistrationHandler;
import org.silverpeas.servlets.credentials.RegisterHandler;
import org.silverpeas.servlets.credentials.ResetLoginPasswordHandler;
import org.silverpeas.servlets.credentials.ResetPasswordHandler;
import org.silverpeas.servlets.credentials.SendMessageHandler;
import org.silverpeas.servlets.credentials.TermsOfServiceRequestHandler;
import org.silverpeas.servlets.credentials.TermsOfServiceResponseHandler;
import org.silverpeas.servlets.credentials.ValidationAnswerHandler;
import org.silverpeas.servlets.credentials.ValidationQuestionHandler;

public class CredentialsServlet
extends HttpServlet {
    private static final long serialVersionUID = -7586840606648226466L;
    private static final Map<String, FunctionHandler> handlers = new HashMap<String, FunctionHandler>(20);

    private static void initHandlers() {
        handlers.put("ForcePasswordChange", new ForcePasswordChangeHandler());
        handlers.put("EffectiveChangePassword", new EffectiveChangePasswordHandler());
        handlers.put("EffectiveChangePasswordBeforeExpiration", new EffectiveChangePasswordBeforeExpirationHandler());
        handlers.put("ChangeQuestion", new ChangeQuestionHandler());
        handlers.put("ValidateQuestion", new ValidationQuestionHandler());
        handlers.put("LoginQuestion", new LoginQuestionHandler());
        handlers.put("ValidateAnswer", new ValidationAnswerHandler());
        handlers.put("ChangePassword", new ChangePasswordHandler());
        handlers.put("ChangePasswordFromLogin", new ChangePasswordFromLoginHandler());
        handlers.put("EffectiveChangePasswordFromLogin", new EffectiveChangePasswordFromLoginHandler());
        handlers.put("ChangeExpiredPassword", new ChangeExpiredPasswordHandler());
        handlers.put("ForgotPassword", new ForgotPasswordHandler());
        handlers.put("ResetPassword", new ResetPasswordHandler());
        handlers.put("ResetLoginPassword", new ResetLoginPasswordHandler());
        handlers.put("SendMessage", new SendMessageHandler());
        handlers.put("NewRegistration", new NewRegistrationHandler());
        handlers.put("Register", new RegisterHandler());
        handlers.put("TermsOfServiceRequest", new TermsOfServiceRequestHandler());
        handlers.put("TermsOfServiceResponse", new TermsOfServiceResponseHandler());
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String function = this.getFunction(request);
        FunctionHandler handler = handlers.get(function);
        if (handler != null) {
            UserDetail user = null;
            String login = request.getParameter("Login");
            String domainId = request.getParameter("DomainId");
            String destinationPage = "";
            AuthenticationUserVerifierFactory.getUserCanTryAgainToLoginVerifier(user).clearSession(request);
            if (StringUtil.isDefined((String)login) && StringUtil.isDefined((String)domainId)) {
                UserCanLoginVerifier userStateVerifier = AuthenticationUserVerifierFactory.getUserCanLoginVerifier((AuthenticationCredential)AuthenticationCredential.newWithAsLogin((String)login).withAsDomainId(domainId));
                try {
                    user = userStateVerifier.getUser();
                    userStateVerifier.verify();
                }
                catch (AuthenticationException e) {
                    destinationPage = userStateVerifier.getErrorDestination();
                }
            }
            if (!StringUtil.isDefined((String)destinationPage)) {
                destinationPage = handler.doAction(request);
            }
            if (destinationPage.startsWith("http")) {
                AuthenticationUserVerifierFactory.getUserCanTryAgainToLoginVerifier(user).clearCache();
                Cookie sessionCookie = new Cookie("JSESSIONID", request.getSession().getId());
                sessionCookie.setMaxAge(-1);
                sessionCookie.setSecure(false);
                sessionCookie.setPath(request.getContextPath());
                response.addCookie(sessionCookie);
                response.sendRedirect(response.encodeRedirectURL(destinationPage));
                return;
            }
            RequestDispatcher dispatcher = request.getRequestDispatcher(destinationPage);
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        } else {
            response.sendError(404, "command not found : " + function);
        }
    }

    private String getFunction(HttpServletRequest request) {
        String function = "Error";
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            pathInfo = pathInfo.substring(1);
            function = pathInfo.substring(pathInfo.indexOf(47) + 1);
        }
        return function;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    static {
        CredentialsServlet.initHandlers();
    }
}

