/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.servlets.credentials;

import com.stratelia.silverpeas.peasCore.MainSessionController;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.ResourceLocator;
import com.stratelia.webactiv.util.viewGenerator.html.GraphicElementFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.silverpeas.authentication.AuthenticationCredential;
import org.silverpeas.authentication.AuthenticationService;
import org.silverpeas.authentication.exception.AuthenticationException;
import org.silverpeas.servlets.credentials.ChangePasswordFunctionHandler;

public class EffectiveChangePasswordBeforeExpirationHandler
extends ChangePasswordFunctionHandler {
    @Override
    public String doAction(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        MainSessionController controller = (MainSessionController)session.getAttribute("SilverSessionController");
        if (controller == null) {
            return "/Login.jsp";
        }
        ResourceLocator settings = new ResourceLocator("com.silverpeas.authentication.settings.passwordExpiration", "");
        String passwordChangeURL = settings.getString("passwordChangeURL", "/defaultPasswordAboutToExpire.jsp");
        UserDetail ud = controller.getCurrentUserDetail();
        try {
            String login = ud.getLogin();
            String domainId = ud.getDomainId();
            String oldPassword = request.getParameter("oldPassword");
            String newPassword = request.getParameter("newPassword");
            AuthenticationCredential credential = AuthenticationCredential.newWithAsLogin((String)login).withAsPassword(oldPassword).withAsDomainId(domainId);
            AuthenticationService authenticator = new AuthenticationService();
            authenticator.changePassword(credential, newPassword);
            GraphicElementFactory gef = (GraphicElementFactory)session.getAttribute("SessionGraphicElementFactory");
            String favoriteFrame = gef.getLookFrame();
            return "/Main/" + favoriteFrame;
        }
        catch (AuthenticationException e) {
            SilverTrace.error((String)"peasCore", (String)"effectiveChangePasswordHandler.doAction()", (String)"peasCore.EX_USER_KEY_NOT_FOUND", (Throwable)e);
            return this.performUrlChangePasswordError(request, passwordChangeURL, ud);
        }
    }
}

