/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.servlets.credentials;

import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.Domain;
import java.util.List;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import org.silverpeas.authentication.AuthenticationService;
import org.silverpeas.authentication.exception.AuthenticationException;
import org.silverpeas.authentication.password.ForgottenPasswordException;
import org.silverpeas.authentication.password.ForgottenPasswordMailManager;
import org.silverpeas.authentication.password.ForgottenPasswordMailParameters;
import org.silverpeas.servlets.credentials.FunctionHandler;

public class ForgotPasswordHandler
extends FunctionHandler {
    private static AuthenticationService authenticator = new AuthenticationService();
    private ForgottenPasswordMailManager forgottenPasswordMailManager = new ForgottenPasswordMailManager();

    @Override
    public String doAction(HttpServletRequest request) {
        String userId;
        String login = request.getParameter("Login");
        String domainId = request.getParameter("DomainId");
        try {
            userId = this.getAdmin().getUserIdByLoginAndDomain(login, domainId);
        }
        catch (AdminException e) {
            request.setAttribute("login", (Object)login);
            List domains = authenticator.getAllDomains();
            String domain = "";
            for (Domain aDomain : domains) {
                if (!aDomain.getId().equals(domainId)) continue;
                domain = aDomain.getName();
            }
            request.setAttribute("domain", (Object)domain);
            return this.getGeneral().getString("forgottenPasswordInvalidLogin");
        }
        try {
            if (authenticator.isPasswordChangeAllowed(domainId)) {
                String authenticationKey;
                try {
                    authenticationKey = authenticator.getAuthenticationKey(login, domainId);
                }
                catch (AuthenticationException e) {
                    throw new ForgottenPasswordException("CredentialsServlet.forgotPasswordHandler.doAction()", "forgottenPassword.EX_GET_USER_AUTHENTICATION_KEY", "login=" + login + " ; domainId=" + domainId, (Exception)((Object)e));
                }
                try {
                    ForgottenPasswordMailParameters parameters = this.getMailParameters(userId);
                    parameters.setLink(this.getContextPath(request) + "/ResetPassword?key=" + authenticationKey);
                    this.forgottenPasswordMailManager.sendResetPasswordRequestMail(parameters);
                    return this.getGeneral().getString("forgottenPasswordChangeAllowed");
                }
                catch (AdminException e) {
                    throw new ForgottenPasswordException("CredentialsServlet.forgotPasswordHandler.doAction()", "forgottenPassword.EX_GET_USER_DETAIL", "userId=" + userId, (Exception)((Object)e));
                }
                catch (MessagingException e) {
                    throw new ForgottenPasswordException("CredentialsServlet.forgotPasswordHandler.doAction()", "forgottenPassword.EX_SEND_MAIL", "userId=" + userId, (Exception)((Object)e));
                }
            }
            return this.getGeneral().getString("forgottenPasswordChangeNotAllowed");
        }
        catch (ForgottenPasswordException fpe) {
            return this.forgottenPasswordError(request, fpe);
        }
    }
}

