/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.servlets.credentials;

import com.silverpeas.util.FileUtil;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.Admin;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.AdminReference;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.ResourceLocator;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import org.silverpeas.authentication.password.ForgottenPasswordException;
import org.silverpeas.authentication.password.ForgottenPasswordMailManager;
import org.silverpeas.authentication.password.ForgottenPasswordMailParameters;

public abstract class FunctionHandler {
    private ResourceBundle resources;
    private ResourceLocator m_Multilang;
    private ForgottenPasswordMailManager forgottenPasswordMailManager;
    private ResourceLocator general = new ResourceLocator("org.silverpeas.lookAndFeel.generalLook", "");
    private ResourceLocator authenticationSettings = new ResourceLocator("org.silverpeas.authentication.settings.authenticationSettings", "");

    public FunctionHandler() {
        this.resources = FileUtil.loadBundle((String)"org.silverpeas.peasCore.SessionManager", (Locale)Locale.ROOT);
        String language = this.resources.getString("language");
        if (!StringUtil.isDefined((String)language)) {
            language = "fr";
        }
        this.m_Multilang = new ResourceLocator("org.silverpeas.peasCore.multilang.peasCoreBundle", language);
        this.forgottenPasswordMailManager = new ForgottenPasswordMailManager();
    }

    public abstract String doAction(HttpServletRequest var1);

    protected ForgottenPasswordMailParameters getMailParameters(String userId) throws AdminException {
        ForgottenPasswordMailParameters parameters = new ForgottenPasswordMailParameters();
        UserDetail userDetail = this.getAdmin().getUserDetail(userId);
        parameters.setUserName(userDetail.getDisplayedName());
        parameters.setLogin(userDetail.getLogin());
        parameters.setDomainId(userDetail.getDomainId());
        parameters.setToAddress(userDetail.geteMail());
        return parameters;
    }

    protected String getContextPath(HttpServletRequest request) {
        String requestUrl = request.getRequestURL().toString();
        String servletPath = request.getServletPath();
        String contextPath = requestUrl.substring(0, requestUrl.indexOf(servletPath) + servletPath.length());
        return contextPath;
    }

    protected String forgottenPasswordError(HttpServletRequest request, ForgottenPasswordException fpe) {
        String error = SilverTrace.getTraceMessage((String)fpe.getMessage()) + " - " + fpe.getExtraInfos();
        ForgottenPasswordMailParameters parameters = new ForgottenPasswordMailParameters();
        parameters.setError(error);
        try {
            this.getForgottenPasswordMailManager().sendErrorMail(parameters);
        }
        catch (MessagingException e) {
            SilverTrace.error((String)"peasCore", (String)"CredentialsServlet.forgottenPasswordError()", (String)"forgottenPassword.EX_SEND_MAIL", (Throwable)e);
        }
        request.setAttribute("error", (Object)error);
        return this.getGeneral().getString("forgottenPasswordError");
    }

    protected ResourceBundle getResources() {
        return this.resources;
    }

    protected void setResources(ResourceBundle resources) {
        this.resources = resources;
    }

    protected ResourceLocator getM_Multilang() {
        return this.m_Multilang;
    }

    protected void setM_Multilang(ResourceLocator m_Multilang) {
        this.m_Multilang = m_Multilang;
    }

    protected ForgottenPasswordMailManager getForgottenPasswordMailManager() {
        return this.forgottenPasswordMailManager;
    }

    protected void setForgottenPasswordMailManager(ForgottenPasswordMailManager forgottenPasswordMailManager) {
        this.forgottenPasswordMailManager = forgottenPasswordMailManager;
    }

    protected Admin getAdmin() {
        return AdminReference.getAdminService();
    }

    protected ResourceLocator getGeneral() {
        return this.general;
    }

    protected void setGeneral(ResourceLocator general) {
        this.general = general;
    }

    public ResourceLocator getAuthenticationSettings() {
        return this.authenticationSettings;
    }
}

