/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.servlets.credentials;

import com.silverpeas.admin.service.UserService;
import com.silverpeas.admin.service.UserServiceProvider;
import com.stratelia.webactiv.beans.admin.AdminException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.silverpeas.servlets.credentials.FunctionHandler;
import org.silverpeas.servlets.credentials.RegistrationSettings;

public class RegisterHandler
extends FunctionHandler {
    public static final String REGISTRATION_TOKEN = "registrationToken";
    private RegistrationSettings settings = RegistrationSettings.getSettings();

    @Override
    public String doAction(HttpServletRequest request) {
        String firstName = request.getParameter("firstName");
        String lastName = request.getParameter("lastName");
        String email = request.getParameter("email");
        String token = request.getParameter(REGISTRATION_TOKEN);
        if (this.settings.isUserSelfRegistrationEnabled()) {
            try {
                UserService service = UserServiceProvider.getInstance().getService();
                service.registerUser(firstName, lastName, email, "0");
            }
            catch (AdminException e) {
                return "/admin/jsp/registrationFailed.jsp";
            }
            return "/admin/jsp/registrationSuccess.jsp";
        }
        Logger.getLogger(this.getClass().getSimpleName()).log(Level.WARNING, "A user is trying to register himself although this capability is deactived! Registration information: [firstname: {0}, lastname: {1}, email: {2}]", new Object[]{firstName, lastName, email});
        return "";
    }
}

