/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.servlets.credentials;

import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.UserFull;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import org.silverpeas.authentication.AuthenticationCredential;
import org.silverpeas.authentication.AuthenticationService;
import org.silverpeas.authentication.exception.AuthenticationException;
import org.silverpeas.authentication.password.ForgottenPasswordException;
import org.silverpeas.authentication.password.ForgottenPasswordMailParameters;
import org.silverpeas.password.service.PasswordServiceFactory;
import org.silverpeas.servlets.credentials.FunctionHandler;

public class ResetPasswordHandler
extends FunctionHandler {
    @Override
    public String doAction(HttpServletRequest request) {
        try {
            String authenticationKey = request.getParameter("key");
            String userId = null;
            try {
                userId = this.getAdmin().getUserIdByAuthenticationKey(authenticationKey);
            }
            catch (Exception e) {
                return this.getGeneral().getString("forgottenPasswordResetError");
            }
            if (userId != null) {
                UserFull user;
                String password = PasswordServiceFactory.getPasswordService().generate();
                ForgottenPasswordMailParameters parameters = null;
                try {
                    parameters = this.getMailParameters(userId);
                }
                catch (AdminException e) {
                    throw new ForgottenPasswordException("CredentialsServlet.resetPasswordHandler.doAction()", "forgottenPassword.EX_GET_USER_DETAIL", "userId=" + userId, (Exception)((Object)e));
                }
                try {
                    user = this.getAdmin().getUserFull(userId);
                }
                catch (AdminException e) {
                    throw new ForgottenPasswordException("CredentialsServlet.resetPasswordHandler.doAction()", "forgottenPassword.EX_GET_FULL_USER_DETAIL", "userId=" + userId, (Exception)((Object)e));
                }
                try {
                    AuthenticationCredential credential = AuthenticationCredential.newWithAsLogin((String)user.getLogin()).withAsDomainId(user.getDomainId());
                    AuthenticationService authenticator = new AuthenticationService();
                    authenticator.resetPassword(credential, password);
                }
                catch (AuthenticationException e1) {
                    throw new ForgottenPasswordException("CredentialsServlet.resetPasswordHandler.doAction()", "forgottenPassword.EX_RESET_PASSWORD_FAILED", "userId=" + userId, (Exception)((Object)e1));
                }
                parameters.setPassword(password);
                parameters.setLink(this.getContextPath(request) + "/ResetLoginPassword" + "?login=" + user.getLogin() + "&domainId=" + user.getDomainId());
                try {
                    this.getForgottenPasswordMailManager().sendNewPasswordMail(parameters);
                }
                catch (MessagingException e) {
                    throw new ForgottenPasswordException("CredentialsServlet.resetPasswordHandler.doAction()", "forgottenPassword.EX_SEND_MAIL", "userId=" + userId, (Exception)((Object)e));
                }
                return this.getGeneral().getString("forgottenPasswordReset");
            }
            return this.getGeneral().getString("forgottenPasswordResetError");
        }
        catch (ForgottenPasswordException fpe) {
            return this.forgottenPasswordError(request, fpe);
        }
    }
}

