/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.servlets.credentials;

import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminException;
import javax.servlet.http.HttpServletRequest;
import org.silverpeas.authentication.verifier.AuthenticationUserVerifierFactory;
import org.silverpeas.authentication.verifier.UserMustAcceptTermsOfServiceVerifier;
import org.silverpeas.cache.service.CacheServiceFactory;
import org.silverpeas.servlet.HttpServletRequestWrapper;
import org.silverpeas.servlets.credentials.FunctionHandler;

public class TermsOfServiceResponseHandler
extends FunctionHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String doAction(HttpServletRequest request) {
        HttpServletRequestWrapper requestWrapper = new HttpServletRequestWrapper(request, I18NHelper.defaultLanguage);
        String tosToken = requestWrapper.getParameter("tosToken");
        if (StringUtil.isDefined((String)tosToken)) {
            UserMustAcceptTermsOfServiceVerifier verifier = AuthenticationUserVerifierFactory.getUserMustAcceptTermsOfServiceVerifier((String)tosToken);
            if (verifier.getUser() == null) {
                return this.getErrorDestination("Error_UserTosTimeout");
            }
            try {
                boolean tosAccepted = requestWrapper.getParameterAsBoolean("tosAccepted");
                if (!tosAccepted) {
                    String string = this.getErrorDestination("Error_UserTosRefused");
                    return string;
                }
                try {
                    this.getAdmin().userAcceptsTermsOfService(verifier.getUser().getId());
                }
                catch (AdminException e) {
                    SilverTrace.error((String)"peasCore", (String)"TermsOfServiceResponseHandler.doAction()", (String)"peasCore.EX_USER_KEY_NOT_FOUND", (String)("login=" + verifier.getUser().getLogin()));
                    String string = this.getErrorDestination("2");
                    verifier.clearCache();
                    return string;
                }
                request.setAttribute("internalAuthToken", (Object)CacheServiceFactory.getCacheService().add((Object)verifier.getUser()));
                request.setAttribute("skipTermsOfServiceAcceptance", (Object)true);
                String string = "/AuthenticationServlet";
                return string;
            }
            finally {
                verifier.clearCache();
            }
        }
        return this.getErrorDestination("2");
    }

    private String getErrorDestination(String errorCode) {
        return "/Login.jsp?ErrorCode=" + errorCode;
    }
}

