/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.servlets.credentials;

import com.silverpeas.authentication.SilverpeasSessionOpener;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.UserDetail;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.silverpeas.servlets.credentials.FunctionHandler;
import org.silverpeas.util.crypto.CryptMD5;

public class ValidationQuestionHandler
extends FunctionHandler {
    private static final SilverpeasSessionOpener sessionOpenener = new SilverpeasSessionOpener();

    @Override
    public String doAction(HttpServletRequest request) {
        HttpSession session = request.getSession();
        String key = (String)session.getAttribute("svplogin_Key");
        boolean answerCrypted = this.getAuthenticationSettings().getBoolean("loginAnswerCrypted", false);
        try {
            String userId = this.getAdmin().authenticate(key, session.getId(), false, false);
            UserDetail userDetail = this.getAdmin().getUserDetail(userId);
            String question = request.getParameter("question");
            String answer = request.getParameter("answer");
            userDetail.setLoginQuestion(question);
            if (answerCrypted) {
                answer = CryptMD5.encrypt((String)answer);
            }
            userDetail.setLoginAnswer(answer);
            this.getAdmin().updateUser(userDetail);
            if (this.getGeneral().getBoolean("userLoginForcePasswordChange", false)) {
                return this.getGeneral().getString("userLoginForcePasswordChangePage");
            }
            return sessionOpenener.openSession(request, key);
        }
        catch (AdminException e) {
            SilverTrace.error((String)"peasCore", (String)"validationQuestionHandler.doAction()", (String)"peasCore.EX_USER_KEY_NOT_FOUND", (Throwable)e);
            return "/Login.jsp";
        }
    }
}

