/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.sharing.web;

import com.silverpeas.annotation.RequestScoped;
import com.silverpeas.annotation.Service;
import com.silverpeas.sharing.model.Ticket;
import com.silverpeas.sharing.services.SharingServiceFactory;
import com.silverpeas.web.RESTWebService;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.publication.web.PublicationResource;
import org.silverpeas.sharing.web.SharingEntity;

@Service
@RequestScoped
@Path(value="sharing/{token}")
public class SharingResource
extends RESTWebService {
    @PathParam(value="token")
    private String token;

    @Override
    public String getComponentId() {
        return null;
    }

    @GET
    @Produces(value={"application/json"})
    public SharingEntity getSharing() {
        String baseUri = this.getUriInfo().getBaseUri().toString();
        Ticket ticket = SharingServiceFactory.getSharingTicketService().getTicket(this.token);
        if (ticket == null || !ticket.isValid()) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        URI webApplicationRootUri = this.getWebApplicationRootUri(baseUri, ticket.getComponentId(), String.valueOf(ticket.getSharedObjectId()));
        Date expiration = ticket.getEndDate();
        return new SharingEntity(this.getUriInfo().getRequestUri(), webApplicationRootUri, expiration);
    }

    private URI getWebApplicationRootUri(String baseUri, String componentId, String nodeId) {
        URI uri;
        try {
            uri = new URI(baseUri + "nodes/" + componentId + "/" + this.token + "/" + nodeId);
        }
        catch (URISyntaxException e) {
            Logger.getLogger(PublicationResource.class.getName()).log(Level.SEVERE, null, e);
            throw new RuntimeException(e.getMessage(), e);
        }
        return uri;
    }
}

