/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.subscription;

import com.silverpeas.personalization.UserPreferences;
import com.silverpeas.subscribe.SubscriptionResource;
import com.silverpeas.util.CollectionUtil;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.node.model.NodeDetail;
import java.util.ArrayList;
import java.util.Collection;
import org.silverpeas.subscription.SubscriptionResourcePath;

public class SubscriptionContext {
    private UserDetail user;
    private UserPreferences userPreferences;
    private InternalContext internalContext;

    public SubscriptionContext(UserDetail user, UserPreferences userPreferences) {
        this.user = user;
        this.userPreferences = userPreferences;
    }

    public void initialize(SubscriptionResource resource) {
        this.internalContext = new InternalContext();
        this.internalContext.resource = resource;
    }

    public void initialize(SubscriptionResource resource, Collection<SubscriptionResourcePath> resourcePath) {
        this.initialize(resource);
        if (CollectionUtil.isNotEmpty(resourcePath)) {
            this.internalContext.path.addAll(resourcePath);
        }
    }

    public void initializeFromNode(SubscriptionResource resource, Collection<NodeDetail> nodePath) {
        ArrayList<SubscriptionResourcePath> resourcePath = new ArrayList<SubscriptionResourcePath>(nodePath.size());
        for (NodeDetail node : nodePath) {
            resourcePath.add(new SubscriptionResourcePath(node.getName(this.userPreferences.getLanguage()), node.getLink()));
        }
        this.initialize(resource, resourcePath);
    }

    public UserDetail getUser() {
        return this.user;
    }

    public SubscriptionResource getResource() {
        return this.internalContext.resource;
    }

    public Collection<SubscriptionResourcePath> getPath() {
        return this.internalContext.path;
    }

    public String getDestinationUrl() {
        return this.internalContext.destinationUrl;
    }

    private class InternalContext {
        public String destinationUrl = "/RSubscription/jsp/Main";
        public SubscriptionResource resource = null;
        public Collection<SubscriptionResourcePath> path = new ArrayList<SubscriptionResourcePath>();

        private InternalContext() {
        }
    }
}

