/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.subscription.bean;

import com.silverpeas.subscribe.Subscription;
import com.silverpeas.subscribe.SubscriptionResource;
import com.silverpeas.subscribe.SubscriptionSubscriber;
import com.silverpeas.subscribe.constant.SubscriberType;
import com.silverpeas.subscribe.constant.SubscriptionMethod;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.webactiv.beans.admin.ComponentInstLight;
import com.stratelia.webactiv.beans.admin.Group;
import com.stratelia.webactiv.beans.admin.SpaceInstLight;
import com.stratelia.webactiv.beans.admin.UserDetail;
import java.util.Date;
import org.silverpeas.core.admin.OrganisationControllerFactory;

public abstract class AbstractSubscriptionBean
implements Subscription {
    private final Subscription subscription;
    private final String language;
    private UserDetail user = null;
    private Group group = null;
    private SpaceInstLight space = null;
    private ComponentInstLight component = null;

    protected AbstractSubscriptionBean(Subscription subscription, ComponentInstLight component, String language) {
        this.subscription = subscription;
        this.component = component;
        this.language = language;
    }

    public String getLanguage() {
        return this.language;
    }

    public SubscriptionResource getResource() {
        return this.subscription.getResource();
    }

    public SubscriptionSubscriber getSubscriber() {
        return this.subscription.getSubscriber();
    }

    public SubscriptionMethod getSubscriptionMethod() {
        return this.subscription.getSubscriptionMethod();
    }

    public String getCreatorId() {
        return this.subscription.getCreatorId();
    }

    public Date getCreationDate() {
        return this.subscription.getCreationDate();
    }

    public boolean isReadOnly() {
        return SubscriberType.GROUP.equals((Object)this.getSubscriber().getType());
    }

    public String getPath() {
        return this.getSpace().getName() + " > " + this.getComponent().getLabel();
    }

    public String getLink() {
        return URLManager.getSimpleURL((int)1, (String)this.subscription.getResource().getInstanceId());
    }

    public String getSubscriberName() {
        switch (this.getSubscriber().getType()) {
            case USER: {
                return this.getUser().getDisplayedName();
            }
            case GROUP: {
                return this.getGroup().getName();
            }
        }
        return "";
    }

    protected UserDetail getUser() {
        if (this.user == null) {
            this.user = UserDetail.getById((String)this.getSubscriber().getId());
            if (this.user == null) {
                this.user = new UserDetail();
            }
        }
        return this.user;
    }

    protected Group getGroup() {
        if (this.group == null) {
            this.group = OrganisationControllerFactory.getOrganisationController().getGroup(this.getSubscriber().getId());
            if (this.group == null) {
                this.group = new Group();
            }
        }
        return this.group;
    }

    public ComponentInstLight getComponent() {
        if (this.component == null) {
            this.component = OrganisationControllerFactory.getOrganisationController().getComponentInstLight(this.subscription.getResource().getInstanceId());
            if (this.component == null) {
                this.component = new ComponentInstLight();
            }
        }
        return this.component;
    }

    public SpaceInstLight getSpace() {
        if (this.space == null) {
            this.space = OrganisationControllerFactory.getOrganisationController().getSpaceInstLightById(this.component.getDomainFatherId());
            if (this.space == null) {
                this.space = new SpaceInstLight();
            }
        }
        return this.space;
    }
}

