/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.upload.web;

import com.silverpeas.annotation.Authenticated;
import com.silverpeas.annotation.RequestScoped;
import com.silverpeas.annotation.Service;
import com.silverpeas.util.StringUtil;
import com.silverpeas.web.RESTWebService;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.FileRepositoryManager;
import com.sun.jersey.multipart.FormDataBodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.json.JSONObject;
import org.silverpeas.util.Charsets;
import org.silverpeas.util.UnitUtil;
import org.silverpeas.web.util.IFrameAjaxTransportUtil;

@Service
@RequestScoped
@Path(value="fileUpload")
@Authenticated
public class FileUploadResource
extends RESTWebService {
    private static final String X_FILENAME = "X-FILENAME";

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/html"})
    public Response uploadFiles(FormDataMultiPart multiPart) {
        try {
            String uploadId = UUID.randomUUID().toString();
            ArrayList<JSONObject> jsonFiles = new ArrayList<JSONObject>();
            List files = multiPart.getFields("file_upload");
            int numFile = 0;
            for (FormDataBodyPart file : files) {
                jsonFiles.add(this.uploadFile(uploadId + "-" + numFile++, file.getFormDataContentDisposition().getFileName(), (InputStream)file.getValueAs(InputStream.class)));
            }
            return Response.ok().entity((Object)IFrameAjaxTransportUtil.packJSonDataWithHtmlContainer(jsonFiles)).build();
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"text/html"})
    public Response uploadFile(InputStream inputStream) {
        try {
            String fileName = new String(this.getHttpServletRequest().getHeader(X_FILENAME).getBytes(Charsets.ISO_8859_1), Charsets.UTF_8);
            if (!StringUtil.isDefined((String)fileName)) {
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
            String fileId = UUID.randomUUID().toString();
            JSONObject jsonFile = this.uploadFile(fileId, fileName, inputStream);
            return Response.ok().entity((Object)IFrameAjaxTransportUtil.packJSonDataWithHtmlContainer(jsonFile)).build();
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    private JSONObject uploadFile(String fileId, String fileName, InputStream inputStream) throws IOException {
        File uploadedFileLocation = this.getDestinationFileName(fileId, fileName);
        this.saveToFile(inputStream, uploadedFileLocation);
        return this.toJSONObject(fileId, uploadedFileLocation);
    }

    private JSONObject toJSONObject(String fileId, File file) {
        JSONObject fileInfos = new JSONObject();
        fileInfos.put("fileId", (Object)fileId);
        fileInfos.put("name", (Object)file.getName().substring(fileId.length() + 1));
        fileInfos.put("size", (double)file.length());
        fileInfos.put("formattedSize", (Object)UnitUtil.formatMemSize((BigDecimal)new BigDecimal(String.valueOf(file.length()))));
        fileInfos.put("iconUrl", (Object)FileRepositoryManager.getFileIcon((String)FilenameUtils.getExtension((String)file.getName())));
        return fileInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFile(InputStream uploadedInputStream, File uploadedFileLocation) throws IOException {
        try {
            FileOutputStream fOS = FileUtils.openOutputStream((File)uploadedFileLocation);
            try {
                IOUtils.copy((InputStream)uploadedInputStream, (OutputStream)fOS);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)fOS);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)uploadedInputStream);
        }
    }

    @DELETE
    @Path(value="{fileId}")
    @Produces(value={"application/json"})
    public Response delete(@PathParam(value="fileId") String fileId) {
        try {
            File tempDir = new File(FileRepositoryManager.getTemporaryPath());
            Collection files = FileUtils.listFiles((File)tempDir, (IOFileFilter)new PrefixFileFilter(fileId), (IOFileFilter)FalseFileFilter.FALSE);
            if (!files.isEmpty()) {
                for (File file : files) {
                    FileUtils.deleteQuietly((File)file);
                }
            } else {
                SilverTrace.error((String)"upload", (String)"FileUploadResource.delete()", (String)"", (String)("Trying to delete unexisting file with id: " + fileId));
            }
            return Response.ok().build();
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    private File getDestinationFileName(String fileId, String fileName) {
        return new File(this.getBaseFileName(fileId) + "-" + fileName);
    }

    private File getBaseFileName(String fileId) {
        return new File(FileRepositoryManager.getTemporaryPath(), fileId);
    }

    @Override
    public String getComponentId() {
        return "";
    }
}

