/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.viewer.web;

import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.peasCore.URLManager;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.viewer.DocumentView;
import org.silverpeas.viewer.web.AbstractPreviewEntity;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DocumentViewEntity
extends AbstractPreviewEntity<DocumentViewEntity> {
    private static final long serialVersionUID = 4270519541076741138L;
    @XmlElement(defaultValue="")
    private final String displayLicenseKey;
    @XmlElement(defaultValue="")
    private final String displayViewerPath;
    @XmlElement(defaultValue="")
    private final String url;
    @XmlElement(defaultValue="")
    private final String originalFileName;
    @XmlElement(defaultValue="")
    private final String width;
    @XmlElement(defaultValue="")
    private final String height;
    @XmlElement(defaultValue="")
    private final String language;
    @XmlElement(defaultValue="")
    private final int nbPages;

    public static DocumentViewEntity createFrom(DocumentView documentView, String language) {
        return new DocumentViewEntity(documentView, language);
    }

    protected DocumentViewEntity(DocumentView documentView, String language) {
        this.displayLicenseKey = documentView.getDisplayLicenseKey();
        this.displayViewerPath = StringUtil.isDefined((String)this.displayLicenseKey) ? "/weblib/flexpaper/flash" : URLManager.getApplicationURL() + "/util/flash/flexpaper";
        this.url = documentView.getURLAsString();
        this.originalFileName = documentView.getOriginalFileName();
        this.width = documentView.getWidth();
        this.height = documentView.getHeight();
        this.language = language;
        this.nbPages = documentView.getNbPages();
    }

    protected String getDisplayLicenseKey() {
        return this.displayLicenseKey;
    }

    protected String getDisplayViewerPath() {
        return this.displayViewerPath;
    }

    protected String getUrl() {
        return this.url;
    }

    protected String getOriginalFileName() {
        return this.originalFileName;
    }

    protected String getWidth() {
        return this.width;
    }

    protected String getHeight() {
        return this.height;
    }

    protected String getLanguage() {
        return this.language;
    }

    protected int getNbPages() {
        return this.nbPages;
    }
}

