/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.viewer.web;

import com.silverpeas.annotation.Authorized;
import com.silverpeas.annotation.RequestScoped;
import com.silverpeas.annotation.Service;
import com.silverpeas.web.RESTWebService;
import java.io.File;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.attachment.AttachmentService;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.attachment.model.SimpleDocumentPK;
import org.silverpeas.viewer.DocumentView;
import org.silverpeas.viewer.ViewService;
import org.silverpeas.viewer.exception.PreviewException;
import org.silverpeas.viewer.web.DocumentViewEntity;

@Service
@RequestScoped
@Path(value="view/{componentId}")
@Authorized
public class DocumentViewResource
extends RESTWebService {
    @Inject
    @Named(value="simpleDocumentService")
    private AttachmentService attachmentService;
    @Inject
    private ViewService viewService;
    @PathParam(value="componentId")
    private String componentId;

    @GET
    @Path(value="attachment/{id}")
    @Produces(value={"application/json"})
    public DocumentViewEntity getAttachmentView(@PathParam(value="id") String id) {
        try {
            SimpleDocument attachment = this.attachmentService.searchDocumentById(new SimpleDocumentPK(id, this.getComponentId()), this.getUserPreferences().getLanguage());
            if (attachment == null) {
                throw new PreviewException("ATTACHMENT DOESN'T EXIST");
            }
            return this.asWebEntity(this.viewService.getDocumentView(attachment.getFilename(), new File(attachment.getAttachmentPath())));
        }
        catch (PreviewException pe) {
            throw new WebApplicationException((Throwable)pe, Response.Status.NOT_FOUND);
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    protected DocumentViewEntity asWebEntity(DocumentView documentView) {
        return (DocumentViewEntity)DocumentViewEntity.createFrom(documentView, this.getUserPreferences().getLanguage()).withURI(this.getUriInfo().getRequestUri());
    }

    @Override
    public String getComponentId() {
        return this.componentId;
    }
}

