/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.web.filter;

import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.webactiv.util.ResourceLocator;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpMethod;

public class WebCORSFilter
implements Filter {
    private static final ResourceLocator settings = new ResourceLocator("org.silverpeas.general", "");
    private static final String ALL_DOMAINS_ALLOWED = "*";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.addHeader("Access-Control-Allow-Origin", this.getAllowedDomains(httpRequest));
        if (HttpMethod.OPTIONS.name().equals(httpRequest.getMethod())) {
            httpResponse.addHeader("Access-Control-Allow-Methods", "GET, POST, DELETE, PUT, OPTIONS");
            httpResponse.addHeader("Access-Control-Allow-Headers", "Content-Type, X-Silverpeas-Session");
        }
        chain.doFilter(request, response);
    }

    private String getAllowedDomains(HttpServletRequest httpRequest) {
        String allowedDomain;
        String allowedDomains = settings.getString("web.request.domain.allowed", "");
        if (ALL_DOMAINS_ALLOWED.equals(allowedDomains)) {
            allowedDomain = ALL_DOMAINS_ALLOWED;
        } else {
            String serverOrigin = httpRequest.getHeader("Origin");
            List<String> allowedDomainList = Arrays.asList(allowedDomains.split(", "));
            allowedDomain = StringUtil.isDefined((String)serverOrigin) && allowedDomainList.contains(serverOrigin) ? serverOrigin : URLManager.getServerURL((HttpServletRequest)httpRequest);
        }
        return allowedDomain;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

