/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.web.util;

import com.silverpeas.util.StringUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.UriInfo;

public class URIUtil {
    private static final char separator = '/';

    public static URI buildURI(UriInfo uriInfo, String ... uriPathParts) {
        return URIUtil.buildURI(uriInfo.getBaseUri().toString(), uriPathParts);
    }

    public static URI buildURI(String uriBase, String ... uriPathParts) {
        try {
            return new URI(URIUtil.buildStringURI(uriBase, uriPathParts));
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(URIUtil.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private static String buildStringURI(String uriBase, String ... uriPathParts) {
        if (!StringUtil.isDefined((String)uriBase)) {
            return "";
        }
        StringBuilder stringURI = new StringBuilder(uriBase);
        if (uriPathParts != null) {
            for (String pathPart : uriPathParts) {
                if (stringURI.charAt(stringURI.length() - 1) != '/') {
                    stringURI.append('/');
                }
                stringURI.append(pathPart);
            }
        }
        return stringURI.toString();
    }
}

