/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.kmelia;

import com.silverpeas.form.DataRecord;
import com.silverpeas.form.Form;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.RecordSet;
import com.silverpeas.form.fileitem.InternalFileItem;
import com.silverpeas.form.importExport.XMLField;
import com.silverpeas.publicationTemplate.PublicationTemplate;
import com.silverpeas.publicationTemplate.PublicationTemplateManager;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.kmelia.control.ejb.KmeliaBmEJB;
import com.stratelia.webactiv.kmelia.model.KmeliaRuntimeException;
import com.stratelia.webactiv.util.DateUtil;
import com.stratelia.webactiv.util.EJBUtilitaire;
import com.stratelia.webactiv.util.JNDINames;
import com.stratelia.webactiv.util.node.model.NodeDetail;
import com.stratelia.webactiv.util.node.model.NodePK;
import com.stratelia.webactiv.util.publication.control.PublicationBm;
import com.stratelia.webactiv.util.publication.model.PublicationDetail;
import com.stratelia.webactiv.util.publication.model.PublicationPK;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.silverpeas.search.SearchEngineFactory;
import org.silverpeas.search.searchEngine.model.MatchingIndexEntry;
import org.silverpeas.search.searchEngine.model.ParseException;
import org.silverpeas.search.searchEngine.model.QueryDescription;

public class PublicationImport {
    private KmeliaBmEJB kmeliaBm;
    private String componentId;
    private String topicId;
    private String spaceId;
    private String userId;
    private boolean ignoreMissingFormFields = false;

    public PublicationImport(KmeliaBmEJB kmeliaBm, String componentId, String topicId, String spaceId, String userId) {
        this.kmeliaBm = kmeliaBm;
        this.componentId = componentId;
        this.topicId = topicId;
        this.spaceId = spaceId;
        this.userId = userId;
    }

    public PublicationImport(KmeliaBmEJB kmeliaBm, String componentId) {
        this.kmeliaBm = kmeliaBm;
        this.componentId = componentId;
    }

    public void importPublications(List<Map<String, String>> publiParamsList, List<Map<String, String>> formParamsList, String language, String xmlFormName, String discrimatingParameterName, String userProfile) {
        for (int i = 0; i < publiParamsList.size(); ++i) {
            this.importPublication(publiParamsList.get(i), formParamsList.get(i), language, xmlFormName, discrimatingParameterName, userProfile);
        }
    }

    public boolean importPublication(Map<String, String> publiParams, Map<String, String> formParams, String language, String xmlFormName, String discrimatingParameterName, String userProfile) {
        String publicationToUpdateId = null;
        if (discrimatingParameterName != null && discrimatingParameterName.length() > 0) {
            String discrimatingParameterValue = formParams.get(discrimatingParameterName);
            publicationToUpdateId = this.getPublicationId(xmlFormName, discrimatingParameterName, discrimatingParameterValue);
        }
        return this.importPublication(publicationToUpdateId, publiParams, formParams, language, xmlFormName, userProfile);
    }

    public boolean importPublication(String publicationToUpdateId, Map<String, String> publiParams, Map<String, String> formParams, String language, String xmlFormName, String userProfile) {
        PublicationPK pubPK;
        boolean resultStatus;
        PublicationDetail pubDetail = null;
        if (publicationToUpdateId != null) {
            try {
                resultStatus = false;
                pubPK = new PublicationPK(publicationToUpdateId, this.spaceId, this.componentId);
                pubDetail = this.kmeliaBm.getPublicationDetail(pubPK);
                this.updatePublicationDetail(pubDetail, publiParams, language);
                this.updatePublication(pubDetail, true);
            }
            catch (Exception e) {
                throw new KmeliaRuntimeException("PublicationImport.importPublication()", 4, "kmelia.EX_IMPOSSIBLE_DIMPORTER_PUBLICATION", e);
            }
        }
        try {
            resultStatus = true;
            pubDetail = this.getPublicationDetail(publiParams, language);
            this.createPublication(pubDetail);
            pubDetail.setInfoId(xmlFormName);
            this.updatePublication(pubDetail, true);
            pubPK = pubDetail.getPK();
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("PublicationImport.importPublication()", 4, "kmelia.EX_IMPOSSIBLE_DIMPORTER_PUBLICATION", e);
        }
        try {
            String pubId = pubPK.getId();
            PublicationTemplateManager publicationTemplateManager = PublicationTemplateManager.getInstance();
            publicationTemplateManager.addDynamicPublicationTemplate(this.componentId + ":" + xmlFormName, xmlFormName + ".xml");
            PublicationTemplate pub = publicationTemplateManager.getPublicationTemplate(this.componentId + ":" + xmlFormName);
            RecordSet set = pub.getRecordSet();
            Form form = pub.getUpdateForm();
            DataRecord data = set.getRecord(pubId, language);
            if (data == null) {
                data = set.getEmptyRecord();
                data.setId(pubId);
                data.setLanguage(language);
            }
            PagesContext context = new PagesContext("myForm", "3", language, false, this.componentId, this.userId);
            context.setNodeId(this.topicId);
            context.setObjectId(pubId);
            context.setContentLanguage(language);
            if (this.ignoreMissingFormFields) {
                context.setUpdatePolicy(1);
            }
            ArrayList<InternalFileItem> items = new ArrayList<InternalFileItem>();
            for (String fieldName : data.getFieldNames()) {
                String fieldValue = formParams.get(fieldName);
                fieldValue = fieldValue == null ? "" : fieldValue;
                items.add(new InternalFileItem(fieldName, fieldValue));
            }
            form.update(items, data, context);
            set.save(data);
            this.updatePublication(pubDetail, true);
            NodePK nodePK = new NodePK(this.topicId, this.spaceId, this.componentId);
            this.kmeliaBm.draftOutPublication(pubPK, nodePK, userProfile, true);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("PublicationImport.importPublication()", 4, "kmelia.EX_IMPOSSIBLE_DIMPORTER_PUBLICATION", e);
        }
        return resultStatus;
    }

    public List<XMLField> getPublicationXmlFields(String publicationId) {
        return this.getPublicationXmlFields(publicationId, null);
    }

    public List<XMLField> getPublicationXmlFields(String publicationId, String language) {
        PublicationPK pubPK = new PublicationPK(publicationId, this.spaceId, this.componentId);
        PublicationDetail pubDetail = this.kmeliaBm.getPublicationDetail(pubPK);
        return pubDetail.getXmlFields(language);
    }

    private PublicationDetail getPublicationDetail(Map<String, String> parameters, String language) throws Exception {
        String id = parameters.get("PubId");
        String status = parameters.get("Status");
        String name = parameters.get("Name");
        String description = parameters.get("Description");
        String keywords = parameters.get("Keywords");
        String beginDate = parameters.get("BeginDate");
        String endDate = parameters.get("EndDate");
        String version = parameters.get("Version");
        String importance = parameters.get("Importance");
        String beginHour = parameters.get("BeginHour");
        String endHour = parameters.get("EndHour");
        String author = parameters.get("Author");
        String validatorId = parameters.get("ValideurId");
        String tempId = parameters.get("TempId");
        String infoId = parameters.get("InfoId");
        String creationDate = parameters.get("CreationDate");
        String updateDate = parameters.get("UpdateDate");
        Date jBeginDate = null;
        Date jEndDate = null;
        Date jCreationDate = null;
        Date jUpdateDate = null;
        if (StringUtil.isDefined((String)beginDate)) {
            jBeginDate = DateUtil.stringToDate((String)beginDate, (String)language);
        }
        if (StringUtil.isDefined((String)endDate)) {
            jEndDate = DateUtil.stringToDate((String)endDate, (String)language);
        }
        if (StringUtil.isDefined((String)creationDate)) {
            jCreationDate = DateUtil.stringToDate((String)creationDate, (String)language);
        }
        if (StringUtil.isDefined((String)updateDate)) {
            jUpdateDate = DateUtil.stringToDate((String)updateDate, (String)language);
        }
        if (!StringUtil.isInteger((String)importance)) {
            importance = "5";
        }
        String pubId = StringUtil.isDefined((String)id) ? id : "X";
        PublicationDetail pubDetail = new PublicationDetail(pubId, name, description, jCreationDate, jBeginDate, jEndDate, null, importance, version, keywords, "", status, "", author);
        pubDetail.setBeginHour(beginHour);
        pubDetail.setEndHour(endHour);
        pubDetail.setUpdateDate(jUpdateDate);
        if (StringUtil.isDefined((String)validatorId)) {
            pubDetail.setTargetValidatorId(validatorId);
        }
        pubDetail.setCloneId(tempId);
        if (StringUtil.isDefined((String)infoId)) {
            pubDetail.setInfoId(infoId);
        }
        return pubDetail;
    }

    private String createPublication(PublicationDetail pubDetail) {
        pubDetail.getPK().setSpace(this.spaceId);
        pubDetail.getPK().setComponentName(this.componentId);
        pubDetail.setCreatorId(this.userId);
        if (pubDetail.getCreationDate() == null) {
            pubDetail.setCreationDate(new Date());
        }
        NodePK nodePK = new NodePK(this.topicId, this.spaceId, this.componentId);
        String result = this.kmeliaBm.createPublicationIntoTopic(pubDetail, nodePK);
        SilverTrace.info((String)"kmelia", (String)"PublicationImport.createPublication()", (String)"Kmelia.MSG_ENTRY_METHOD");
        return result;
    }

    private void updatePublication(PublicationDetail pubDetail, boolean forceUpdateDate) {
        pubDetail.getPK().setSpace(this.spaceId);
        pubDetail.getPK().setComponentName(this.componentId);
        pubDetail.setUpdaterId(this.userId);
        pubDetail.setIndexOperation(-1);
        this.kmeliaBm.updatePublication(pubDetail, forceUpdateDate);
    }

    public String getPublicationId(String xmlFormName, String fieldName, String fieldValue) {
        QueryDescription query = new QueryDescription("*");
        query.setSearchingUser(this.userId);
        query.addSpaceComponentPair(this.spaceId, this.componentId);
        HashMap<String, String> newXmlQuery = new HashMap<String, String>();
        newXmlQuery.put(xmlFormName + "$$" + fieldName, fieldValue);
        query.setXmlQuery(newXmlQuery);
        try {
            List result = SearchEngineFactory.getSearchEngine().search(query).getEntries();
            for (MatchingIndexEntry mie : result) {
                if (!"Publication".equals(mie.getObjectType())) continue;
                return mie.getPK().getObjectId();
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String createTopic(String name, String description) {
        NodeDetail topic = new NodeDetail("-1", name, description, null, null, null, "0", "X");
        topic.getNodePK().setSpace(this.spaceId);
        topic.getNodePK().setComponentName(this.componentId);
        topic.setCreatorId(this.userId);
        NodePK fatherPK = new NodePK(this.topicId, this.spaceId, this.componentId);
        String alertType = "None";
        NodePK nodePK = this.kmeliaBm.addSubTopic(fatherPK, topic, alertType);
        return nodePK.getId();
    }

    public Collection<String> getPublicationsSpecificValues(String componentId, String xmlFormName, String fieldName) {
        PublicationBm publicationBm = this.getPublicationBm();
        Collection publications = publicationBm.getAllPublications(new PublicationPK("useless", componentId));
        ArrayList<String> result = new ArrayList<String>();
        for (PublicationDetail publication : publications) {
            String fieldValue;
            NodePK fatherPK;
            Collection fatherPKs;
            if (!publication.getInfoId().equals(xmlFormName) || (fatherPKs = publicationBm.getAllFatherPK(publication.getPK())).isEmpty() || (fatherPK = (NodePK)fatherPKs.iterator().next()).isTrash() || !StringUtil.isDefined((String)(fieldValue = publication.getFieldValue(fieldName)))) continue;
            result.add(fieldValue);
        }
        return result;
    }

    public void draftInPublication(String xmlFormName, String fieldName, String fieldValue) {
        String publicationId = this.getPublicationId(xmlFormName, fieldName, fieldValue);
        if (publicationId != null) {
            PublicationPK publicationPK = new PublicationPK(publicationId, this.componentId);
            this.kmeliaBm.draftInPublication(publicationPK);
        }
    }

    public void updatePublicationEndDate(String xmlFormName, String fieldName, String fieldValue, Date endDate) {
        String publicationToUpdateId = this.getPublicationId(xmlFormName, fieldName, fieldValue);
        PublicationPK publicationPK = new PublicationPK(publicationToUpdateId, this.spaceId, this.componentId);
        PublicationDetail pubDetail = this.kmeliaBm.getPublicationDetail(publicationPK);
        Date publicationEndDate = pubDetail.getEndDate();
        if (publicationEndDate == null || publicationEndDate.after(endDate)) {
            pubDetail.setEndDate(endDate);
            this.updatePublication(pubDetail, false);
        }
    }

    private void updatePublicationDetail(PublicationDetail pubDetail, Map<String, String> parameters, String language) throws Exception {
        String status = parameters.get("Status");
        String name = parameters.get("Name");
        String description = parameters.get("Description");
        String keywords = parameters.get("Keywords");
        String beginDate = parameters.get("BeginDate");
        String endDate = parameters.get("EndDate");
        String version = parameters.get("Version");
        String importance = parameters.get("Importance");
        String beginHour = parameters.get("BeginHour");
        String endHour = parameters.get("EndHour");
        String author = parameters.get("Author");
        String validatorId = parameters.get("ValideurId");
        String tempId = parameters.get("TempId");
        String infoId = parameters.get("InfoId");
        String updateDate = parameters.get("UpdateDate");
        if (StringUtil.isDefined((String)updateDate)) {
            pubDetail.setUpdateDate(DateUtil.stringToDate((String)updateDate, (String)language));
        }
        if (StringUtil.isDefined((String)beginDate)) {
            pubDetail.setBeginDate(DateUtil.stringToDate((String)beginDate, (String)language));
        }
        if (StringUtil.isDefined((String)endDate)) {
            pubDetail.setEndDate(DateUtil.stringToDate((String)endDate, (String)language));
        }
        if (name != null) {
            pubDetail.setName(name);
        }
        if (description != null) {
            pubDetail.setDescription(description);
        }
        if (StringUtil.isInteger((String)importance)) {
            pubDetail.setImportance(Integer.parseInt(importance));
        }
        if (version != null) {
            pubDetail.setVersion(version);
        }
        if (keywords != null) {
            pubDetail.setKeywords(keywords);
        }
        if (author != null) {
            pubDetail.setAuthor(author);
        }
        pubDetail.setBeginHour(beginHour);
        pubDetail.setEndHour(endHour);
        if (status != null) {
            pubDetail.setStatus(status);
        }
        if (StringUtil.isDefined((String)validatorId)) {
            pubDetail.setTargetValidatorId(validatorId);
        }
        pubDetail.setCloneId(tempId);
        if (StringUtil.isDefined((String)infoId)) {
            pubDetail.setInfoId(infoId);
        }
    }

    public void setIgnoreMissingFormFields(boolean ignore) {
        this.ignoreMissingFormFields = ignore;
    }

    private PublicationBm getPublicationBm() {
        return (PublicationBm)EJBUtilitaire.getEJBObjectRef((String)JNDINames.PUBLICATIONBM_EJBHOME, PublicationBm.class);
    }
}

