/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.kmelia.model;

import com.stratelia.webactiv.kmelia.model.KmeliaPublication;
import com.stratelia.webactiv.util.node.model.NodeDetail;
import com.stratelia.webactiv.util.node.model.NodePK;
import com.stratelia.webactiv.util.publication.model.PublicationDetail;
import com.stratelia.webactiv.util.publication.model.PublicationPK;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TopicDetail
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Collection<NodeDetail> path;
    private NodeDetail nodeDetail;
    private Collection<KmeliaPublication> publications;

    public TopicDetail() {
        this.init(null, null, null);
    }

    public TopicDetail(Collection<NodeDetail> path, NodeDetail nodeDetail, Collection<KmeliaPublication> kmeliaPublication) {
        this.init(path, nodeDetail, kmeliaPublication);
    }

    private void init(Collection<NodeDetail> path, NodeDetail nodeDetail, Collection<KmeliaPublication> kmeliaPublications) {
        this.path = path;
        this.nodeDetail = nodeDetail;
        this.publications = kmeliaPublications;
    }

    public Collection<NodeDetail> getPath() {
        return this.path;
    }

    public NodePK getNodePK() {
        return this.nodeDetail.getNodePK();
    }

    public NodeDetail getNodeDetail() {
        return this.nodeDetail;
    }

    public Collection<KmeliaPublication> getKmeliaPublications() {
        return this.publications;
    }

    public void setPath(Collection<NodeDetail> path) {
        this.path = path;
    }

    public void setNodeDetail(NodeDetail nd) {
        this.nodeDetail = nd;
    }

    public void setPublicationDetails(Collection<KmeliaPublication> pd) {
        this.publications = pd;
    }

    public List<KmeliaPublication> getValidPublications() {
        return this.getValidPublications(null);
    }

    public List<KmeliaPublication> getValidPublications(PublicationPK pubPKToExclude) {
        ArrayList<KmeliaPublication> validPublications = new ArrayList<KmeliaPublication>();
        for (KmeliaPublication aPublication : this.publications) {
            PublicationDetail detail = aPublication.getDetail();
            if (detail.getStatus() == null || !detail.getStatus().equals("Valid")) continue;
            if (pubPKToExclude == null) {
                validPublications.add(aPublication);
                continue;
            }
            if (detail.getPK().equals((Object)pubPKToExclude)) continue;
            validPublications.add(aPublication);
        }
        return validPublications;
    }
}

