/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.kmelia.notification;

import com.silverpeas.kmelia.notification.AbstractKmeliaPublicationUserNotification;
import com.silverpeas.notification.builder.UserSubscriptionNotificationBehavior;
import com.silverpeas.subscribe.SubscriptionResource;
import com.silverpeas.subscribe.SubscriptionSubscriber;
import com.silverpeas.subscribe.constant.SubscriberType;
import com.silverpeas.subscribe.service.NodeSubscriptionResource;
import com.silverpeas.subscribe.service.ResourceSubscriptionProvider;
import com.silverpeas.subscribe.util.SubscriptionSubscriberList;
import com.silverpeas.subscribe.util.SubscriptionSubscriberMapBySubscriberType;
import com.stratelia.silverpeas.notificationManager.constant.NotifAction;
import com.stratelia.webactiv.beans.admin.ObjectType;
import com.stratelia.webactiv.util.node.model.NodeDetail;
import com.stratelia.webactiv.util.node.model.NodePK;
import com.stratelia.webactiv.util.publication.model.PublicationDetail;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.silverpeas.core.admin.OrganisationController;

public class KmeliaSubscriptionPublicationUserNotification
extends AbstractKmeliaPublicationUserNotification
implements UserSubscriptionNotificationBehavior {
    private SubscriptionSubscriberMapBySubscriberType subscriberIdsByTypes = new SubscriptionSubscriberMapBySubscriberType(new SubscriptionSubscriber[0]);
    private Collection<String> userIdsToExcludeFromNotifying = new HashSet<String>();

    public KmeliaSubscriptionPublicationUserNotification(NodePK nodePK, PublicationDetail resource, NotifAction action) {
        super(nodePK, resource, action);
    }

    protected void initialize() {
        super.initialize();
        this.subscriberIdsByTypes.addAll((Collection)ResourceSubscriptionProvider.getSubscribersOfSubscriptionResource((SubscriptionResource)NodeSubscriptionResource.from((NodePK)this.getNodePK())));
        List allUserSubscriberIds = this.subscriberIdsByTypes.getAllUserIds();
        if (!allUserSubscriberIds.isEmpty()) {
            OrganisationController orgaController = this.getOrganisationController();
            NodeDetail node = this.getNodeHeader(this.getNodePK());
            for (String userId : allUserSubscriberIds) {
                if (orgaController.isComponentAvailable(this.getNodePK().getInstanceId(), userId) && (!node.haveRights() || orgaController.isObjectAvailable(node.getRightsDependsOn(), ObjectType.NODE, this.getNodePK().getInstanceId(), userId))) continue;
                this.userIdsToExcludeFromNotifying.add(userId);
            }
        }
    }

    protected void perform(PublicationDetail resource) {
        super.perform((Object)resource);
        this.getNotificationMetaData().displayReceiversInFooter();
    }

    protected String getBundleSubjectKey() {
        return "Subscription";
    }

    protected String getFileName() {
        if (NotifAction.CREATE.equals((Object)this.getAction())) {
            return "notificationSubscriptionCreate";
        }
        if (NotifAction.UPDATE.equals((Object)this.getAction())) {
            return "notificationSubscriptionUpdate";
        }
        return "notificationSubscriptionOtherAction";
    }

    protected Collection<String> getUserIdsToNotify() {
        return ((SubscriptionSubscriberList)this.subscriberIdsByTypes.get((Object)SubscriberType.USER)).getAllIds();
    }

    protected Collection<String> getUserIdsToExcludeFromNotifying() {
        return this.userIdsToExcludeFromNotifying;
    }

    protected Collection<String> getGroupIdsToNotify() {
        return ((SubscriptionSubscriberList)this.subscriberIdsByTypes.get((Object)SubscriberType.GROUP)).getAllIds();
    }
}

