/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.kmelia.control.ejb;

import com.stratelia.webactiv.kmelia.control.ejb.KmeliaServiceProvider;
import com.stratelia.webactiv.util.publication.model.PublicationDetail;
import com.stratelia.webactiv.util.publication.model.PublicationPK;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class KmeliaValidation {
    private final String validatorId;
    private boolean force = false;
    private boolean validatorHasNoMoreRight = false;
    private Set<PublicationPK> pubPkOfPerformedValidations = new HashSet<PublicationPK>(500);

    private KmeliaValidation(String validatorId) {
        this.validatorId = validatorId;
    }

    public static KmeliaValidation by(String validatorId) {
        return new KmeliaValidation(validatorId);
    }

    KmeliaValidation forceValidation() {
        if (this.validatorHasNoMoreRight) {
            throw new IllegalArgumentException("forces the validation whereas the validator has no more right to validate");
        }
        this.force = true;
        return this;
    }

    KmeliaValidation validatorHasNoMoreRight() {
        if (this.force) {
            throw new IllegalArgumentException("indicates the validator ha no more right to validate whereas the validation is indicated to be forced");
        }
        this.validatorHasNoMoreRight = true;
        return this;
    }

    void validate(List<PublicationDetail> publications) {
        for (PublicationDetail publication : publications) {
            this.validate(publication);
        }
    }

    void validate(PublicationDetail publication) {
        PublicationPK publicationPkToValidate;
        if (!(this.force || publication.isClone() || publication.isValidationRequired())) {
            return;
        }
        if (publication.isClone()) {
            publicationPkToValidate = publication.getClonePK();
            PublicationDetail clone = KmeliaServiceProvider.getKmeliaService().getPublicationDetail(publication.getPK());
            if (clone == null || !this.force && !clone.isValidationRequired()) {
                return;
            }
        } else {
            publicationPkToValidate = publication.getPK();
        }
        if (this.pubPkOfPerformedValidations.contains(publicationPkToValidate)) {
            return;
        }
        KmeliaServiceProvider.getKmeliaService().validatePublication(publicationPkToValidate, this.validatorId, this.force, this.validatorHasNoMoreRight);
        this.pubPkOfPerformedValidations.add(publicationPkToValidate);
    }
}

