/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.kmelia.stats;

import com.silverpeas.kmelia.model.StatisticActivityVO;
import com.silverpeas.kmelia.model.StatsFilterVO;
import com.silverpeas.kmelia.stats.StatisticService;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.Admin;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.AdminReference;
import com.stratelia.webactiv.beans.admin.Group;
import com.stratelia.webactiv.kmelia.model.KmeliaRuntimeException;
import com.stratelia.webactiv.util.EJBUtilitaire;
import com.stratelia.webactiv.util.JNDINames;
import com.stratelia.webactiv.util.WAPrimaryKey;
import com.stratelia.webactiv.util.node.control.NodeBm;
import com.stratelia.webactiv.util.node.model.NodeDetail;
import com.stratelia.webactiv.util.node.model.NodePK;
import com.stratelia.webactiv.util.publication.control.PublicationBm;
import com.stratelia.webactiv.util.publication.model.PublicationDetail;
import com.stratelia.webactiv.util.publication.model.PublicationPK;
import com.stratelia.webactiv.util.statistic.control.StatisticBm;
import com.stratelia.webactiv.util.statistic.model.StatisticRuntimeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.inject.Named;

@Named(value="statisticService")
public class StatisticServiceImpl
implements StatisticService {
    private PublicationBm publicationBm;
    private NodeBm nodeBm;
    private StatisticBm statisticBm;

    @Override
    public Integer getNbConsultedPublication(StatsFilterVO statFilter) {
        if (statFilter != null) {
            return this.getNumberOfConsultedPublications(statFilter);
        }
        return -1;
    }

    @Override
    public Integer getNbStatisticActivityByPeriod(StatsFilterVO statFilter) {
        if (statFilter != null) {
            List<PublicationDetail> publis = this.getValidApplicationPublications(statFilter);
            if (publis != null && publis.size() > 0) {
                return this.countGlobalPublicationActivity(statFilter, publis);
            }
            return 0;
        }
        return -1;
    }

    private Integer getNumberOfConsultedPublications(StatsFilterVO statFilter) {
        List<PublicationDetail> publis = this.getValidApplicationPublications(statFilter);
        int nbPubli = 0;
        if (publis != null && publis.size() > 0) {
            Integer groupId = statFilter.getGroupId();
            List<WAPrimaryKey> publiPKs = this.getPrimaryKeysFromPublis(publis);
            if (groupId != null) {
                List<String> userIds = this.getListUserIdsFromGroup(groupId);
                try {
                    nbPubli = this.getStatisticBm().getCountByPeriodAndUser(publiPKs, "Publication", statFilter.getStartDate(), statFilter.getEndDate(), userIds);
                }
                catch (Exception e) {
                    SilverTrace.error((String)"kmelia", (String)(this.getClass().getSimpleName() + ".getNbConsultedPublication"), (String)"Error when counting number of access (getCountByPeriodAndUser)", (Throwable)e);
                }
            } else {
                try {
                    nbPubli = this.getStatisticBm().getCountByPeriod(publiPKs, 1, "Publication", statFilter.getStartDate(), statFilter.getEndDate());
                }
                catch (Exception e) {
                    SilverTrace.error((String)"kmelia", (String)(this.getClass().getSimpleName() + ".getNbConsultedPublication"), (String)"Error when counting number of access (getCountByPeriod)", (Throwable)e);
                }
            }
        }
        return nbPubli;
    }

    private List<WAPrimaryKey> getPrimaryKeysFromPublis(List<PublicationDetail> publis) {
        ArrayList<WAPrimaryKey> publiPKs = new ArrayList<WAPrimaryKey>();
        for (PublicationDetail publi : publis) {
            publiPKs.add((WAPrimaryKey)publi.getPK());
        }
        return publiPKs;
    }

    private List<String> getListUserIdsFromGroup(Integer groupId) {
        ArrayList<String> userIds = new ArrayList<String>();
        try {
            String[] arrayUserIds;
            Admin admin = AdminReference.getAdminService();
            Group selectedGroup = admin.getGroup(Integer.toString(groupId));
            for (String userId : arrayUserIds = selectedGroup.getUserIds()) {
                userIds.add(userId);
            }
        }
        catch (AdminException e) {
            SilverTrace.error((String)"kmelia", (String)(this.getClass().getSimpleName() + ".getStatisticActivityByPeriod"), (String)"Error when loading the list of filtered users", (Throwable)e);
        }
        return userIds;
    }

    private List<PublicationDetail> getValidApplicationPublications(StatsFilterVO statFilter) {
        NodePK fatherPK = new NodePK(Integer.toString(statFilter.getTopicId()), statFilter.getInstanceId());
        Collection validPubli = null;
        ArrayList<PublicationDetail> publis = new ArrayList<PublicationDetail>();
        ArrayList nodes = this.getNodeBm().getSubTree(fatherPK);
        if (nodes != null) {
            ArrayList<String> fatherIds = new ArrayList<String>();
            for (NodeDetail node : nodes) {
                fatherIds.add(Integer.toString(node.getId()));
            }
            validPubli = this.getPublicationBm().getDetailsByFatherIdsAndStatus(fatherIds, new PublicationPK("", statFilter.getInstanceId()), null, "Valid");
            publis.addAll(validPubli);
        }
        return publis;
    }

    private int countPublicationActivity(StatsFilterVO statFilter, Collection<PublicationDetail> publis, boolean isCreate, boolean isUpdate) {
        int nbPubli;
        block4: {
            Date endTime;
            Date startTime;
            block3: {
                nbPubli = 0;
                startTime = statFilter.getStartDate();
                endTime = statFilter.getEndDate();
                Integer groupId = statFilter.getGroupId();
                if (groupId == null) break block3;
                List<String> userIds = this.getListUserIdsFromGroup(groupId);
                if (userIds.isEmpty()) break block4;
                for (PublicationDetail publi : publis) {
                    for (String userId : userIds) {
                        if (!this.isPubliActivityInsideTimeInterval(startTime, endTime, publi, isCreate, isUpdate) || !this.isUserRelatedWithPubli(publi, userId)) continue;
                        ++nbPubli;
                    }
                }
                break block4;
            }
            for (PublicationDetail publi : publis) {
                if (!this.isPubliActivityInsideTimeInterval(startTime, endTime, publi, isCreate, isUpdate)) continue;
                ++nbPubli;
            }
        }
        return nbPubli;
    }

    private boolean isUserRelatedWithPubli(PublicationDetail publi, String userId) {
        return userId.equals(publi.getCreatorId()) || userId.equals(publi.getUpdaterId()) || userId.equals(publi.getValidatorId());
    }

    private boolean isPubliActivityInsideTimeInterval(Date startTime, Date endTime, PublicationDetail publi, boolean isCreate, boolean isUpdate) {
        Date createDate = publi.getCreationDate();
        Date updateDate = publi.getUpdateDate();
        return isCreate && (createDate.after(startTime) || createDate.equals(startTime)) && createDate.before(endTime) || isUpdate && (updateDate.after(startTime) || updateDate.equals(startTime)) && updateDate.before(endTime);
    }

    private PublicationBm getPublicationBm() {
        if (this.publicationBm == null) {
            try {
                this.publicationBm = (PublicationBm)EJBUtilitaire.getEJBObjectRef((String)JNDINames.PUBLICATIONBM_EJBHOME, PublicationBm.class);
            }
            catch (Exception e) {
                throw new KmeliaRuntimeException("KmeliaSecurity.getPublicationBm()", 4, "kmelia.EX_IMPOSSIBLE_DE_FABRIQUER_PUBLICATIONBM_HOME", e);
            }
        }
        return this.publicationBm;
    }

    private NodeBm getNodeBm() {
        if (this.nodeBm == null) {
            try {
                this.nodeBm = (NodeBm)EJBUtilitaire.getEJBObjectRef((String)JNDINames.NODEBM_EJBHOME, NodeBm.class);
            }
            catch (Exception e) {
                throw new KmeliaRuntimeException("KmeliaBmEJB.getNodeBm()", 4, "kmelia.EX_IMPOSSIBLE_DE_FABRIQUER_NODEBM_HOME", e);
            }
        }
        return this.nodeBm;
    }

    private StatisticBm getStatisticBm() {
        if (this.statisticBm == null) {
            try {
                this.statisticBm = (StatisticBm)EJBUtilitaire.getEJBObjectRef((String)JNDINames.STATISTICBM_EJBHOME, StatisticBm.class);
            }
            catch (Exception e) {
                throw new StatisticRuntimeException("PdcSearchSessionController.getStatisticBm()", 4, "root.EX_CANT_GET_REMOTE_OBJECT", e);
            }
        }
        return this.statisticBm;
    }

    @Override
    public StatisticActivityVO getStatisticActivity(StatsFilterVO statFilter) {
        List<PublicationDetail> publis = this.getValidApplicationPublications(statFilter);
        int nbCreate = this.countCreatePublicationActivity(statFilter, publis);
        int nbUpdate = this.countUpdatePublicationActivity(statFilter, publis);
        StatisticActivityVO statActivity = new StatisticActivityVO(nbCreate, nbUpdate);
        return statActivity;
    }

    private int countCreatePublicationActivity(StatsFilterVO statFilter, List<PublicationDetail> publis) {
        return this.countPublicationActivity(statFilter, publis, true, false);
    }

    private int countUpdatePublicationActivity(StatsFilterVO statFilter, List<PublicationDetail> publis) {
        return this.countPublicationActivity(statFilter, publis, false, true);
    }

    private int countGlobalPublicationActivity(StatsFilterVO statFilter, List<PublicationDetail> publis) {
        return this.countPublicationActivity(statFilter, publis, true, true);
    }

    @Override
    public Integer getNumberOfDifferentConsultedPublications(StatsFilterVO statFilter) {
        List<PublicationDetail> publis;
        if (statFilter != null && (publis = this.getValidApplicationPublications(statFilter)) != null && publis.size() > 0) {
            return this.countDistinctConsultedPublications(statFilter, publis);
        }
        return -1;
    }

    private Integer countDistinctConsultedPublications(StatsFilterVO statFilter, List<PublicationDetail> publis) {
        int nbPubli = 0;
        List<WAPrimaryKey> publiPKs = this.getPrimaryKeysFromPublis(publis);
        if (statFilter.getGroupId() != null) {
            List<String> userIds = this.getListUserIdsFromGroup(statFilter.getGroupId());
            try {
                return this.getStatisticBm().getDistinctCountByPeriodUser(publiPKs, 1, "Publication", statFilter.getStartDate(), statFilter.getEndDate(), userIds);
            }
            catch (Exception e) {
                SilverTrace.error((String)"kmelia", (String)(this.getClass().getSimpleName() + ".getNumberOfDifferentConsu..."), (String)"Error when computing distinct access to publication", (Throwable)e);
            }
        } else {
            try {
                return this.getStatisticBm().getDistinctCountByPeriod(publiPKs, 1, "Publication", statFilter.getStartDate(), statFilter.getEndDate());
            }
            catch (Exception e) {
                SilverTrace.error((String)"kmelia", (String)(this.getClass().getSimpleName() + ".getNumberOfDifferentConsu..."), (String)"Error when computing distinct access to publication", (Throwable)e);
            }
        }
        return nbPubli;
    }
}

