/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.kmelia.model;

import com.silverpeas.util.FileUtil;
import com.stratelia.webactiv.util.FileRepositoryManager;
import com.stratelia.webactiv.util.FileServerUtils;
import java.io.Serializable;

public class FileDetail
implements Serializable {
    private static final long serialVersionUID = -9137458562237749139L;
    private String name;
    private String path;
    private long size;
    private boolean isDirectory;

    public FileDetail(String name, String path, long size, boolean isDirectory) {
        this.name = name;
        this.path = path;
        this.size = size;
        this.isDirectory = isDirectory;
    }

    public String getFileDownloadEstimation() {
        return FileRepositoryManager.getFileDownloadTime((long)this.size);
    }

    public String getFileSize() {
        return FileRepositoryManager.formatFileSize((long)this.size);
    }

    public String getFileIcon() {
        String icon = "";
        int pointIndex = this.name.lastIndexOf(".");
        int theLength = this.name.length();
        if (pointIndex >= 0 && pointIndex + 1 < theLength) {
            String fileType = this.name.substring(pointIndex + 1, theLength);
            icon = FileRepositoryManager.getFileIcon((String)fileType);
        } else {
            icon = FileRepositoryManager.getFileIcon((String)"html");
        }
        return icon;
    }

    public String getFileURL() {
        return FileServerUtils.getUrl((String)this.name, (String)this.path, (String)this.getMimeType());
    }

    public boolean isIsDirectory() {
        return this.isDirectory;
    }

    public String getName() {
        return this.name;
    }

    public String getMimeType() {
        return FileUtil.getMimeType((String)this.name);
    }

    public String getPath() {
        return this.path;
    }

    public long getSize() {
        return this.size;
    }
}

